/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.events;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.network.payload.SyncBagTypesPayload;
import net.silentchaos512.treasurebags.setup.TbRegistries;

@EventBusSubscriber(modid="treasurebags")
public final class ServerEvents {
    private ServerEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerEvents.sendBagTypesToClient(serverPlayer);
        TbRegistries.BAG_TYPE.getErrorMessages(serverPlayer).forEach(arg_0 -> ((Player)player).sendSystemMessage(arg_0));
    }

    private static void sendBagTypesToClient(ServerPlayer playerMP) {
        SyncBagTypesPayload payload = new SyncBagTypesPayload();
        TreasureBags.LOGGER.info("Sending {} bag types to {}", (Object)payload.bagTypes().size(), (Object)playerMP.getScoreboardName());
        PacketDistributor.sendToPlayer((ServerPlayer)playerMP, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

