/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.data;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.silentchaos512.treasurebags.lib.Const;
import net.silentchaos512.treasurebags.lib.StandardEntityGroups;
import net.silentchaos512.treasurebags.loot.SelectBagByRarity;
import net.silentchaos512.treasurebags.loot.SetBagTypeFunction;
import net.silentchaos512.treasurebags.setup.TbItems;
import org.jetbrains.annotations.NotNull;

public class ModLootTables
extends LootTableProvider {
    public ModLootTables(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Collections.emptySet(), VanillaLootTableProvider.create((PackOutput)packOutput, lookupProvider).getTables(), lookupProvider);
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.ENTITY), (Object)new LootTableProvider.SubProviderEntry(Gifts::new, LootContextParamSets.GIFT));
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    private static LootPoolSingletonContainer.Builder<?> treasureBag(ResourceLocation bagType) {
        return LootItem.lootTableItem(TbItems.TREASURE_BAG).apply(SetBagTypeFunction.builder(bagType));
    }

    private static LootPoolSingletonContainer.Builder<?> bagOfRarity(Rarity rarity) {
        return LootItem.lootTableItem(TbItems.TREASURE_BAG).apply(SelectBagByRarity.builder(rarity));
    }

    @Nonnull
    private static LootItemConditionalFunction.Builder<?> setName(Component text) {
        return SetNameFunction.setName((Component)text, (SetNameFunction.Target)SetNameFunction.Target.CUSTOM_NAME);
    }

    private static LootItemConditionalFunction.Builder<?> setCount(int count) {
        return SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count));
    }

    private static LootItemConditionalFunction.Builder<?> setCount(int min, int max) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    @NotNull
    private static LootPoolSingletonContainer.Builder<?> lootItem(Item item) {
        return LootItem.lootTableItem((ItemLike)item);
    }

    private static class Entities
    extends EntityLootSubProvider {
        protected Entities(HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(StandardEntityGroups.BOSS.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemKilledByPlayerCondition.killedByPlayer()).setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).setWeight(3)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).setWeight(6)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.RARE).setWeight(10)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.EPIC).setWeight(7))));
            consumer.accept(StandardEntityGroups.HOSTILE.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemKilledByPlayerCondition.killedByPlayer()).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(200)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).setWeight(10)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).setWeight(5)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.RARE).setWeight(2)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.EPIC).setWeight(1))));
            consumer.accept(StandardEntityGroups.PEACEFUL.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemKilledByPlayerCondition.killedByPlayer()).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(500)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).setWeight(12)).add((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).setWeight(6))));
            consumer.accept(StandardEntityGroups.PLAYER.getLootTable(), LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemKilledByPlayerCondition.killedByPlayer()).add(ModLootTables.treasureBag(Const.Bags.PLAYER))));
        }
    }

    private static class Gifts
    implements LootTableSubProvider {
        private final HolderLookup.Provider registries;

        public Gifts(HolderLookup.Provider registries) {
            this.registries = registries;
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.STARTING_INVENTORY, LootTable.lootTable().withPool(LootPool.lootPool().add(ModLootTables.treasureBag(Const.Bags.SPAWN))));
            Gifts.generateSpawnBag(consumer);
            Gifts.generateDungeonBag(consumer);
            Gifts.generateEnderBag(consumer);
            Gifts.generateFoodBag(consumer);
            this.generateGagBag(consumer);
            Gifts.generateIngotsBag(consumer);
            Gifts.generateLiteracyBag(consumer);
            Gifts.generateNatureBag(consumer);
            this.generateNetherBag(consumer);
            this.generateOceanBag(consumer);
            Gifts.generatePlayerBag(consumer);
            Gifts.generateSticksAndStonesBag(consumer);
            Gifts.generateDefaultBag(consumer);
            Gifts.generateTestBag(consumer);
        }

        private static void generateSpawnBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_SPAWN, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STONE_AXE).apply(ModLootTables.setName((Component)Component.literal((String)"Crude Stone Axe"))).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.MAX_DAMAGE, (Object)72)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STONE_PICKAXE).apply(ModLootTables.setName((Component)Component.literal((String)"Crude Stone Pickaxe"))).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.MAX_DAMAGE, (Object)72)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STONE_SHOVEL).apply(ModLootTables.setName((Component)Component.literal((String)"Crude Stone Shovel"))).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.MAX_DAMAGE, (Object)72)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.OAK_LOG).apply(ModLootTables.setCount(16))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SPRUCE_LOG).apply(ModLootTables.setCount(16))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BIRCH_LOG).apply(ModLootTables.setCount(16))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.JUNGLE_LOG).apply(ModLootTables.setCount(16)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)ItemTags.BEDS))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.APPLE).apply(ModLootTables.setCount(10))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BREAD).apply(ModLootTables.setCount(8))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.CHICKEN).apply(ModLootTables.setCount(8)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.TORCH).apply(ModLootTables.setCount(16, 32)))));
        }

        private static void generateDungeonBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_DUNGEON, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.SIMPLE_DUNGEON))));
        }

        private static void generateEnderBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_ENDER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.ENDER_PEARL).setWeight(20)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.ENDER_EYE).setWeight(5)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.ENDER_CHEST).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GRASS_BLOCK).setWeight(8)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.END_STONE).setWeight(5)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.PURPUR_BLOCK).setWeight(4)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.END_ROD).setWeight(2)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.CHORUS_FLOWER).setWeight(1))));
        }

        private static void generateFoodBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_FOOD, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COOKED_COD).setWeight(10).apply(ModLootTables.setCount(2, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COOKED_SALMON).setWeight(10).apply(ModLootTables.setCount(2, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COOKED_PORKCHOP).setWeight(7).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COOKED_BEEF).setWeight(7).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COOKED_CHICKEN).setWeight(8).apply(ModLootTables.setCount(2, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BREAD).setWeight(12).apply(ModLootTables.setCount(2, 6))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLDEN_CARROT).setWeight(3).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLDEN_APPLE).setWeight(1))));
        }

        private void generateGagBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            consumer.accept(Const.LootTables.BAGS_GAG, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.HOPPER).apply(ModLootTables.setName((Component)Component.literal((String)"Franz")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.LIGHT_BLUE_GLAZED_TERRACOTTA).apply(ModLootTables.setName((Component)Component.literal((String)"Loginar Egg?")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.PINK_WOOL).apply(ModLootTables.setName((Component)Component.literal((String)"Larry's Wool")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STICK).apply(ModLootTables.setCount(2)).apply(ModLootTables.setName((Component)Component.literal((String)"Drumsticks")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.RECOVERY_COMPASS).apply((LootItemFunction.Builder)SetLoreFunction.setLore().addLine((Component)Component.literal((String)"You're too good to need this, right?")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.FURNACE_MINECART).apply((LootItemFunction.Builder)SetLoreFunction.setLore().addLine((Component)Component.literal((String)"Choo Choo!")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLDEN_PICKAXE).apply((LootItemFunction.Builder)SetLoreFunction.setLore().addLine((Component)Component.literal((String)"Don't blink"))).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.MAX_DAMAGE, (Object)1)).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), (NumberProvider)ConstantValue.exactly((float)1.0f)).withEnchantment((Holder)registrylookup.getOrThrow(Enchantments.UNBREAKING), (NumberProvider)ConstantValue.exactly((float)3.0f)).withEnchantment((Holder)registrylookup.getOrThrow(Enchantments.EFFICIENCY), (NumberProvider)ConstantValue.exactly((float)5.0f)).withEnchantment((Holder)registrylookup.getOrThrow(Enchantments.MENDING), (NumberProvider)ConstantValue.exactly((float)1.0f))))));
        }

        private static void generateIngotsBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_INGOTS, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.IRON_INGOT).setWeight(50).apply(ModLootTables.setCount(2, 5))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COPPER_INGOT).setWeight(35).apply(ModLootTables.setCount(3, 9))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLD_INGOT).setWeight(20).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.NETHERITE_INGOT).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.IRON_INGOT).setWeight(5).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)Tags.Items.INGOTS).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COAL).setWeight(20).apply(ModLootTables.setCount(5, 10))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COAL_BLOCK).setWeight(5).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.LAVA_BUCKET).setWeight(1))));
        }

        private static void generateLiteracyBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_LITERACY, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOK).setWeight(12).apply(ModLootTables.setCount(2, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.PAPER).setWeight(15).apply(ModLootTables.setCount(4, 10))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOKSHELF).setWeight(3).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.WRITABLE_BOOK).setWeight(1))).withPool(LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.5f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOK).apply(ModLootTables.setName((Component)Component.literal((String)"That Time I Was Slapped With a Salmon, Vol. 4")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOK).apply(ModLootTables.setName((Component)Component.literal((String)"The Adventures of Tardigrade Man")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOK).apply(ModLootTables.setName((Component)Component.literal((String)"Reading For Dummies")))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BOOK).apply(ModLootTables.setName((Component)Component.literal((String)"The Story of Larry the Sheep"))))));
        }

        private static void generateNatureBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_NATURE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SUGAR_CANE).setWeight(10).apply(ModLootTables.setCount(1, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SHORT_GRASS).setWeight(12).apply(ModLootTables.setCount(4, 12))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.FERN).setWeight(8).apply(ModLootTables.setCount(2, 5))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.VINE).setWeight(7).apply(ModLootTables.setCount(1, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.LILY_PAD).setWeight(6).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.CACTUS).setWeight(5).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.PUMPKIN).setWeight(3).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.MELON).setWeight(3).apply(ModLootTables.setCount(1, 2)))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.CARROT).setWeight(5).apply(ModLootTables.setCount(1, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.POTATO).setWeight(5).apply(ModLootTables.setCount(1, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COCOA_BEANS).setWeight(2).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)Tags.Items.SEEDS).setWeight(10).apply(ModLootTables.setCount(1, 4))).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)Tags.Items.CROPS).setWeight(5).apply(ModLootTables.setCount(1, 4)))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)ItemTags.SAPLINGS).apply(ModLootTables.setCount(2, 4)))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)ItemTags.FLOWERS).apply(ModLootTables.setCount(2, 4)))));
        }

        private void generateNetherBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_NETHER, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.NETHERRACK).setWeight(10).apply(ModLootTables.setCount(3, 12))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SOUL_SAND).setWeight(7).apply(ModLootTables.setCount(2, 6))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BASALT).setWeight(5).apply(ModLootTables.setCount(3, 9))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.QUARTZ).setWeight(3).apply(ModLootTables.setCount(2, 7)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLD_NUGGET).setWeight(5).apply(ModLootTables.setCount(8, 28))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BLAZE_ROD).setWeight(10).apply(ModLootTables.setCount(1, 2))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.MAGMA_CREAM).setWeight(6).apply(ModLootTables.setCount(2, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GHAST_TEAR).setWeight(3)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.WITHER_SKELETON_SKULL).setWeight(1))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(99)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.ANCIENT_DEBRIS).setWeight(1))));
        }

        private void generateOceanBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_OCEAN, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.KELP).setWeight(6).apply(ModLootTables.setCount(6, 18))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SEAGRASS).setWeight(3).apply(ModLootTables.setCount(4, 10))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.SEA_PICKLE).setWeight(1))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COPPER_INGOT).setWeight(5).apply(ModLootTables.setCount(1, 3))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.WATER_BUCKET).setWeight(1)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COD_BUCKET).setWeight(1)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.TROPICAL_FISH_BUCKET).setWeight(1)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.NAUTILUS_SHELL).setWeight(1))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(299)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.TRIDENT).setWeight(1))));
        }

        private static void generatePlayerBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_PLAYER, LootTable.lootTable().withPool(LootPool.lootPool().add(ModLootTables.lootItem(Items.GOLDEN_APPLE))));
        }

        private static void generateSticksAndStonesBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_STICKS_AND_STONES, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STICK).setWeight(24).apply(ModLootTables.setCount(4, 8))).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)Tags.Items.RODS).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.COBBLESTONE).setWeight(36).apply(ModLootTables.setCount(6, 12))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STONE).setWeight(24).apply(ModLootTables.setCount(3, 7))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.ANDESITE).setWeight(15).apply(ModLootTables.setCount(4, 8))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.DIORITE).setWeight(15).apply(ModLootTables.setCount(4, 8))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GRANITE).setWeight(15).apply(ModLootTables.setCount(4, 8))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.DIAMOND).setWeight(1)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.EMERALD).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BONE).setWeight(10).apply(ModLootTables.setCount(2, 4))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BONE_MEAL).setWeight(4).apply(ModLootTables.setCount(3, 8))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.BONE_BLOCK).setWeight(1).apply(ModLootTables.setCount(1, 2)))));
        }

        private static void generateDefaultBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_DEFAULT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.STICK).apply(ModLootTables.setCount(4)))));
        }

        private static void generateTestBag(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.BAGS_TEST, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.IRON_INGOT).apply(ModLootTables.setCount(5))).add((LootPoolEntryContainer.Builder)ModLootTables.lootItem(Items.GOLD_INGOT).apply(ModLootTables.setCount(2))).add(ModLootTables.lootItem(Items.DIAMOND))));
        }
    }
}

