/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Rarity;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.treasurebags.data.BagTypeBuilder;
import net.silentchaos512.treasurebags.lib.Const;
import net.silentchaos512.treasurebags.lib.StandardEntityGroups;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BagTypesProvider
implements DataProvider {
    static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public BagTypesProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String getName() {
        return "Treasure Bags - Bag Types";
    }

    protected List<BagTypeBuilder> getBagTypes() {
        ArrayList<BagTypeBuilder> ret = new ArrayList<BagTypeBuilder>();
        ret.add(new BagTypeBuilder(Const.Bags.SPAWN, "default", Rarity.COMMON, Const.LootTables.BAGS_SPAWN).noMobDrops().colors(Color.LIMEGREEN, Color.SKYBLUE, Color.GOLD));
        ret.add(new BagTypeBuilder(Const.Bags.DUNGEON, "default", Rarity.RARE, Const.LootTables.BAGS_DUNGEON).dropsFromAllMobs().colors(Color.DARKOLIVEGREEN, Color.LIGHTGRAY, Color.GRAY));
        ret.add(new BagTypeBuilder(Const.Bags.ENDER, "default", Rarity.RARE, Const.LootTables.BAGS_ENDER).dropsFromAllMobs().colors(Color.BLACK, Color.PURPLE, Color.DARKORCHID));
        ret.add(new BagTypeBuilder(Const.Bags.FOOD, "default", Rarity.COMMON, Const.LootTables.BAGS_FOOD).dropsFromAllMobs().colors(Color.WHITE, Color.RED, Color.PERU));
        ret.add(new BagTypeBuilder(Const.Bags.GAG, "default", Rarity.UNCOMMON, Const.LootTables.BAGS_GAG).dropsFromAllMobs().colors(Color.INDIANRED, Color.ORANGE, Color.LIGHTGOLDENRODYELLOW));
        ret.add(new BagTypeBuilder(Const.Bags.INGOTS, "default", Rarity.UNCOMMON, Const.LootTables.BAGS_INGOTS).dropsFrom(StandardEntityGroups.BOSS, StandardEntityGroups.HOSTILE).colors(Color.ANTIQUEWHITE.getColor(), Color.OLIVE.getColor(), 0x404040));
        ret.add(new BagTypeBuilder(Const.Bags.LITERACY, "default", Rarity.COMMON, Const.LootTables.BAGS_LITERACY).dropsFromAllMobs().colors(Color.PERU, Color.MINTCREAM, Color.MEDIUMTURQUOISE));
        ret.add(new BagTypeBuilder(Const.Bags.NATURE, "default", Rarity.COMMON, Const.LootTables.BAGS_NATURE).dropsFromAllMobs().colors(Color.FORESTGREEN, Color.SIENNA, Color.OLIVE));
        ret.add(new BagTypeBuilder(Const.Bags.NETHER, "default", Rarity.RARE, Const.LootTables.BAGS_NETHER).dropsFromAllMobs().colors(Color.DARKRED, Color.DARKVIOLET, Color.GOLD));
        ret.add(new BagTypeBuilder(Const.Bags.OCEAN, "default", Rarity.RARE, Const.LootTables.BAGS_OCEAN).dropsFromAllMobs().colors(Color.MEDIUMBLUE, Color.LIGHTSEAGREEN, Color.ORANGE));
        ret.add(new BagTypeBuilder(Const.Bags.PLAYER, "default", Rarity.EPIC, Const.LootTables.BAGS_PLAYER).dropsFrom(StandardEntityGroups.PLAYER).colors(Color.FUCHSIA, Color.CORNFLOWERBLUE, Color.GOLD));
        ret.add(new BagTypeBuilder(Const.Bags.STICKS_AND_STONES, "default", Rarity.COMMON, Const.LootTables.BAGS_STICKS_AND_STONES).dropsFromAllMobs().colors(Color.SLATEGRAY, Color.CHOCOLATE, Color.LIGHTGRAY));
        ret.add(new BagTypeBuilder(Const.Bags.DEFAULT, "example", Rarity.COMMON, Const.LootTables.BAGS_DEFAULT).noMobDrops().colors(Color.WHITE, Color.WHITE, Color.WHITE).displayName((Component)Component.literal((String)"Treasure Bag")));
        ret.add(new BagTypeBuilder(Const.Bags.TEST, "example", Rarity.COMMON, Const.LootTables.BAGS_TEST).noMobDrops().colors(0xFF00FF, 65280, 12092939).displayName((Component)Component.literal((String)"Test Bag")));
        return ret;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        HashSet entries = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.getBagTypes().forEach(builder -> {
            if (entries.contains(builder.bagTypeId)) {
                throw new IllegalStateException("Duplicate bag type: " + String.valueOf(builder.bagTypeId));
            }
            entries.add(builder.bagTypeId);
            Path path = outputFolder.resolve(String.format("data/%s/treasurebags_types/%s.json", builder.bagTypeId.getNamespace(), builder.bagTypeId.getPath()));
            list.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)builder.serialize(), (Path)path));
        });
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }
}

