/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.api.IEntityGroup;
import net.silentchaos512.treasurebags.data.BagTypesProvider;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.lib.StandardEntityGroups;

public class BagTypeBuilder {
    final ResourceLocation bagTypeId;
    private final String group;
    private final Rarity rarity;
    private final ResourceKey<LootTable> lootTable;
    private final Collection<IEntityGroup> dropsFromGroups = new LinkedHashSet<IEntityGroup>();
    private boolean noMobDrops = false;
    private Component displayName;
    private int bagColor;
    private int bagOverlayColor;
    private int bagStringColor;

    public BagTypeBuilder(ResourceLocation bagTypeId, String group, Rarity rarity, ResourceKey<LootTable> lootTable) {
        this.bagTypeId = bagTypeId;
        this.group = group;
        this.rarity = rarity;
        this.lootTable = lootTable;
        this.displayName = Component.translatable((String)String.format("bag.%s.%s", this.bagTypeId.getNamespace(), this.bagTypeId.getPath()));
    }

    public BagTypeBuilder noMobDrops() {
        this.dropsFromGroups.clear();
        this.noMobDrops = true;
        return this;
    }

    public BagTypeBuilder dropsFromAllMobs() {
        return this.dropsFrom(StandardEntityGroups.values());
    }

    public BagTypeBuilder dropsFrom(IEntityGroup ... groups) {
        this.dropsFromGroups.addAll(Arrays.asList(groups));
        return this;
    }

    public BagTypeBuilder displayName(Component text) {
        this.displayName = text;
        return this;
    }

    public BagTypeBuilder colors(int bag, int overlay, int string) {
        this.bagColor = bag;
        this.bagOverlayColor = overlay;
        this.bagStringColor = string;
        return this;
    }

    public BagTypeBuilder colors(Color bag, Color overlay, Color string) {
        return this.colors(bag.getColor(), overlay.getColor(), string.getColor());
    }

    public void validate() {
        if (this.dropsFromGroups.isEmpty() && !this.noMobDrops) {
            BagTypesProvider.LOGGER.warn("Bag type '{}' has no dropsFromGroups. This may be unintentional.", (Object)this.bagTypeId);
        }
    }

    public JsonObject serialize() {
        this.validate();
        BagType bagType = new BagType(this.group, this.rarity, List.copyOf(this.dropsFromGroups), this.bagColor, this.bagOverlayColor, this.bagStringColor, this.displayName, this.lootTable, true);
        DataResult jsonElementDataResult = BagType.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)bagType);
        if (jsonElementDataResult.isError()) {
            TreasureBags.LOGGER.error("Something went wrong serializing bag type \"{}\"", (Object)this.bagTypeId);
        }
        return ((JsonElement)jsonElementDataResult.getOrThrow()).getAsJsonObject();
    }
}

