/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.setup.TbDataComponents;
import net.silentchaos512.treasurebags.setup.TbItems;

public final class TreasureBagIngredient
implements ICustomIngredient {
    public static final MapCodec<TreasureBagIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("bag_type").forGetter(ingredient -> ingredient.typeName)).apply((Applicative)instance, TreasureBagIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TreasureBagIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ingredient -> ingredient.typeName, TreasureBagIngredient::new);
    private final ResourceLocation typeName;

    private TreasureBagIngredient(ResourceLocation typeName) {
        this.typeName = typeName;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        ResourceLocation stackBagId = (ResourceLocation)stack.get(TbDataComponents.BAG_TYPE);
        return this.typeName.equals((Object)stackBagId);
    }

    public Stream<ItemStack> getItems() {
        return Stream.of(((TreasureBagItem)((Object)TbItems.TREASURE_BAG.get())).stackOfType(this.typeName));
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return null;
    }
}

