/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.setup.TbItems;
import net.silentchaos512.treasurebags.setup.TbRegistries;

public final class TreasureBagsCommand {
    private static final SuggestionProvider<CommandSourceStack> bagTypeSuggestions = (ctx, builder) -> SharedSuggestionProvider.suggestResource(TbRegistries.BAG_TYPE.keySet(), (SuggestionsBuilder)builder);

    private TreasureBagsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"treasurebags").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"give").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"bagType", (ArgumentType)ResourceLocationArgument.id()).suggests(bagTypeSuggestions).executes(context -> TreasureBagsCommand.giveBags((CommandContext<CommandSourceStack>)context, 1))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            return TreasureBagsCommand.giveBags((CommandContext<CommandSourceStack>)context, count);
        })))));
        builder.then(Commands.literal((String)"list").executes(TreasureBagsCommand::listBagTypes));
        dispatcher.register(builder);
    }

    private static int giveBags(CommandContext<CommandSourceStack> context, int bagCount) throws CommandSyntaxException {
        ResourceLocation bagTypeId = ResourceLocationArgument.getId(context, (String)"bagType");
        BagType bagType = (BagType)TbRegistries.BAG_TYPE.get(bagTypeId);
        if (bagType == null) {
            ((CommandSourceStack)context.getSource()).sendFailure(TreasureBagsCommand.translate("give.invalid", bagTypeId.toString()));
            return 0;
        }
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"players")) {
            ItemStack stack = ((TreasureBagItem)((Object)TbItems.TREASURE_BAG.get())).stackOfType(bagType, bagCount);
            PlayerUtils.giveItem((Player)player, (ItemStack)stack);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TreasureBagsCommand.translate("give.success", bagCount, bagType.customName(), player.getScoreboardName()), true);
        }
        return 1;
    }

    private static int listBagTypes(CommandContext<CommandSourceStack> context) {
        String str = TbRegistries.BAG_TYPE.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)str), true);
        return 1;
    }

    private static Component translate(String key, Object ... args) {
        return Component.translatable((String)("command.treasurebags." + key), (Object[])args);
    }
}

