/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.lib.TagEntityGroup;
import net.silentchaos512.treasurebags.setup.EntityGroups;

public interface IEntityGroup {
    public static final Codec<IEntityGroup> CODEC = Codec.STRING.comapFlatMap(str -> {
        ResourceLocation id = TreasureBags.getIdWithDefaultNamespace(str);
        if (id == null) {
            return DataResult.error(() -> "Invalid ID for entity group: " + str);
        }
        return DataResult.success((Object)EntityGroups.getOrCreate(id, TagEntityGroup::withDefaultName));
    }, entityGroup -> TreasureBags.shortenId(entityGroup.getId()));
    public static final StreamCodec<RegistryFriendlyByteBuf, IEntityGroup> STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeResourceLocation(val.getId()), buf -> EntityGroups.getOrCreate(buf.readResourceLocation(), TagEntityGroup::withDefaultName));

    public ResourceLocation getId();

    public boolean matches(Entity var1);

    public ResourceKey<LootTable> getLootTable();
}

