/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.silentchaos512.lib.event.InitialSpawnItems;
import net.silentchaos512.lib.util.LootUtils;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.command.TreasureBagsCommand;
import net.silentchaos512.treasurebags.data.DataGenerators;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.setup.EntityGroups;
import net.silentchaos512.treasurebags.setup.TbDataComponents;
import net.silentchaos512.treasurebags.setup.TbIngredientTypes;
import net.silentchaos512.treasurebags.setup.TbItems;
import net.silentchaos512.treasurebags.setup.TbLoot;
import net.silentchaos512.treasurebags.setup.TbRegistries;

class SideProxy {
    private static final ResourceKey<LootTable> STARTING_INVENTORY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)TreasureBags.getId("starting_inventory"));

    SideProxy(IEventBus modEventBus) {
        TbDataComponents.REGISTRAR.register(modEventBus);
        TbIngredientTypes.REGISTRAR.register(modEventBus);
        TbItems.ITEMS.register(modEventBus);
        TbLoot.LOOT_FUNCTIONS.register(modEventBus);
        TbLoot.LOOT_MODIFIERS.register(modEventBus);
        EntityGroups.init();
        modEventBus.addListener(DataGenerators::gatherData);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.addListener(this::onAddReloadListener);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        InitialSpawnItems.add((ResourceLocation)STARTING_INVENTORY.location(), p -> {
            if (p instanceof ServerPlayer) {
                return LootUtils.gift(STARTING_INVENTORY, (ServerPlayer)((ServerPlayer)p));
            }
            return Collections.emptyList();
        });
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)TbRegistries.BAG_TYPE);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        TreasureBagsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    static class Server
    extends SideProxy {
        Server(IEventBus modEventBus) {
            super(modEventBus);
            modEventBus.addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client(IEventBus modEventBus) {
            super(modEventBus);
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::onItemColors);
        }

        private void clientSetup(FMLClientSetupEvent event) {
        }

        private void onItemColors(RegisterColorHandlersEvent.Item event) {
            event.register(TreasureBagItem::getColor, new ItemLike[]{TbItems.TREASURE_BAG});
        }
    }
}

