/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.ColorsFromRegion;
import dev.ftb.mods.ftbchunks.client.map.MapIOUtils;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.SyncTXTask;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointManagerImpl;
import dev.ftb.mods.ftblibrary.math.XZ;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.DeflaterOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapDimension
implements MapTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static MapDimension currentDimension;
    private final MapManager manager;
    public final ResourceKey<Level> dimension;
    private final String safeDimensionId;
    public final Path directory;
    private Map<XZ, MapRegion> regions;
    private WaypointManagerImpl waypointManager;
    private boolean needsSave;
    private Long2IntMap loadedChunkView;

    MapDimension(MapManager manager, ResourceKey<Level> dimension, Path directory) {
        this.manager = manager;
        this.dimension = dimension;
        this.safeDimensionId = this.dimension.location().toString().replace(':', '_');
        this.directory = directory.resolve(this.safeDimensionId);
        this.needsSave = false;
        this.loadedChunkView = new Long2IntOpenHashMap();
    }

    public MapManager getManager() {
        return this.manager;
    }

    public static void clearCurrentDimension() {
        currentDimension = null;
    }

    public static Optional<MapDimension> getCurrent() {
        if (currentDimension == null) {
            if (MapManager.getInstance().isEmpty()) {
                LOGGER.warn("Attempted to access MapManager before it was setup!");
                return Optional.empty();
            }
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return Optional.empty();
            }
            currentDimension = MapManager.getInstance().map(m -> m.getDimension((ResourceKey<Level>)level.dimension())).orElse(null);
        }
        return Optional.ofNullable(currentDimension);
    }

    public String toString() {
        return this.safeDimensionId;
    }

    public Collection<MapRegion> getLoadedRegions() {
        return this.regions == null ? Collections.emptyList() : this.regions.values();
    }

    public int getLoadedView(MapRegion region, int cx, int cz) {
        return this.loadedChunkView.get(ChunkPos.asLong((int)((region.pos.x() << 5) + cx), (int)((region.pos.z() << 5) + cz)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<XZ, MapRegion> getRegions() {
        Object object = this.manager.lock;
        synchronized (object) {
            if (this.regions == null) {
                this.regions = new HashMap<XZ, MapRegion>();
                if (Files.notExists(this.directory, new LinkOption[0])) {
                    try {
                        Files.createDirectories(this.directory, new FileAttribute[0]);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!MapIOUtils.read(this.directory.resolve("dimension.regions"), stream -> {
                    stream.readByte();
                    byte version = stream.readByte();
                    int s = stream.readShort();
                    for (int i = 0; i < s; ++i) {
                        byte x = stream.readByte();
                        byte z = stream.readByte();
                        MapRegion c = new MapRegion(this, XZ.of((int)x, (int)z));
                        this.regions.put(c.pos, c);
                    }
                })) {
                    this.needsSave = true;
                }
            }
            return this.regions;
        }
    }

    public int[] getColors(int x, int z, ColorsFromRegion colors) {
        MapRegion region = this.getRegions().get(XZ.of((int)x, (int)z));
        if (region == null) {
            return null;
        }
        MapRegionData data = region.getDataBlocking();
        return colors.getColors(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion getRegion(XZ pos) {
        Object object = this.manager.lock;
        synchronized (object) {
            Map<XZ, MapRegion> map = this.getRegions();
            MapRegion region = map.get(pos);
            if (region == null) {
                region = new MapRegion(this, pos);
                region.created();
                map.put(pos, region);
            }
            return region;
        }
    }

    public WaypointManagerImpl getWaypointManager() {
        if (this.waypointManager == null) {
            this.waypointManager = WaypointManagerImpl.fromJson(this);
            FTBChunksAPI.clientApi().requestMinimapIconRefresh();
        }
        return this.waypointManager;
    }

    public void release() {
        for (MapRegion region : this.getLoadedRegions()) {
            region.release(true);
        }
        this.regions = null;
        this.waypointManager = null;
    }

    @Override
    public void runMapTask() throws Exception {
        ImmutableList waypoints = ImmutableList.copyOf((Iterable)this.getWaypointManager());
        ImmutableList regionList = ImmutableList.copyOf(this.getRegions().values());
        if (!waypoints.isEmpty() || !regionList.isEmpty()) {
            FTBChunksClient.MAP_EXECUTOR.execute(() -> this.lambda$runMapTask$2((List)waypoints, (List)regionList));
        }
    }

    private void writeData(List<WaypointImpl> waypoints, List<MapRegion> regionList) throws IOException {
        WaypointManagerImpl.writeJson(this, waypoints);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(baos)));){
            stream.writeByte(0);
            stream.writeByte(1);
            stream.writeShort(regionList.size());
            for (MapRegion region : regionList) {
                stream.writeByte(region.pos.x());
                stream.writeByte(region.pos.z());
            }
        }
        Files.write(this.directory.resolve("dimension.regions"), baos.toByteArray(), new OpenOption[0]);
    }

    public void sync() {
        long now = System.currentTimeMillis();
        this.getRegions().values().stream().sorted(Comparator.comparingDouble(MapRegion::distToPlayer)).forEach(region -> ClientTaskQueue.queue(new SyncTXTask((MapRegion)region, now)));
    }

    public void releaseStaleRegionData(long now, long releaseIntervalMillis) {
        if (this.regions != null) {
            this.regions.values().forEach(region -> region.releaseIfStale(now, releaseIntervalMillis));
        }
    }

    public void saveIfChanged() {
        if (this.needsSave) {
            ClientTaskQueue.queue(this);
            this.needsSave = false;
        }
    }

    public void markDirty() {
        this.needsSave = true;
    }

    public void updateLoadedChunkView(Long2IntMap chunks) {
        this.loadedChunkView = chunks;
    }

    private /* synthetic */ void lambda$runMapTask$2(List waypoints, List regionList) {
        try {
            this.writeData(waypoints, regionList);
        }
        catch (Exception ex) {
            FTBChunks.LOGGER.error("Failed to write map dimension " + String.valueOf(this) + ":");
            ex.printStackTrace();
        }
    }
}

