/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry.JEI;

import com.google.common.base.Preconditions;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.dakotapride.garnished.registry.GarnishedItems;
import net.dakotapride.garnished.registry.JEI.BlackDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.BlueDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.BrownDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.CyanDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.FreezingFanCategory;
import net.dakotapride.garnished.registry.JEI.GrayDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.GreenDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LightBlueDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LightGrayDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.LimeDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.MagentaDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.OrangeDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.PinkDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.PurpleDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.RedDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.WhiteDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.JEI.YellowDyeBlowingFanCategory;
import net.dakotapride.garnished.registry.recipe.GarnishedRecipeTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

@ParametersAreNonnullByDefault
@JeiPlugin
public class GarnishedJEI
implements IModPlugin {
    private static final ResourceLocation MOD_ID = CreateGarnished.asResource("jei_plugin");
    private final List<IRecipeCategory<?>> categories = new ArrayList();
    private IIngredientManager ingredientManager;
    public static IJeiRuntime runtime;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MOD_ID;
    }

    private void loadCategories(IRecipeCategoryRegistration registration) {
        this.categories.clear();
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        ArrayList<ProcessingViaFanCategory.MultiOutput> localCategories = new ArrayList<ProcessingViaFanCategory.MultiOutput>();
        localCategories.add(FreezingFanCategory.create(guiHelper));
        localCategories.add(RedDyeBlowingFanCategory.create(GarnishedRecipeTypes.RED_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("red_dye_blowing")), GarnishedFluids.RED_MASTIC_RESIN, "red_dye_blowing"));
        localCategories.add(OrangeDyeBlowingFanCategory.create(GarnishedRecipeTypes.ORANGE_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("orange_dye_blowing")), GarnishedFluids.ORANGE_MASTIC_RESIN, "orange_dye_blowing"));
        localCategories.add(YellowDyeBlowingFanCategory.create(GarnishedRecipeTypes.YELLOW_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("yellow_dye_blowing")), GarnishedFluids.YELLOW_MASTIC_RESIN, "yellow_dye_blowing"));
        localCategories.add(GreenDyeBlowingFanCategory.create(GarnishedRecipeTypes.GREEN_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("green_dye_blowing")), GarnishedFluids.GREEN_MASTIC_RESIN, "green_dye_blowing"));
        localCategories.add(LimeDyeBlowingFanCategory.create(GarnishedRecipeTypes.LIME_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("lime_dye_blowing")), GarnishedFluids.LIME_MASTIC_RESIN, "lime_dye_blowing"));
        localCategories.add(BlueDyeBlowingFanCategory.create(GarnishedRecipeTypes.BLUE_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("blue_dye_blowing")), GarnishedFluids.BLUE_MASTIC_RESIN, "blue_dye_blowing"));
        localCategories.add(LightBlueDyeBlowingFanCategory.create(GarnishedRecipeTypes.LIGHT_BLUE_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("light_blue_dye_blowing")), GarnishedFluids.LIGHT_BLUE_MASTIC_RESIN, "light_blue_dye_blowing"));
        localCategories.add(CyanDyeBlowingFanCategory.create(GarnishedRecipeTypes.CYAN_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("cyan_dye_blowing")), GarnishedFluids.CYAN_MASTIC_RESIN, "cyan_dye_blowing"));
        localCategories.add(PurpleDyeBlowingFanCategory.create(GarnishedRecipeTypes.PURPLE_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("purple_dye_blowing")), GarnishedFluids.PURPLE_MASTIC_RESIN, "purple_dye_blowing"));
        localCategories.add(MagentaDyeBlowingFanCategory.create(GarnishedRecipeTypes.MAGENTA_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("magenta_dye_blowing")), GarnishedFluids.MAGENTA_MASTIC_RESIN, "magenta_dye_blowing"));
        localCategories.add(PinkDyeBlowingFanCategory.create(GarnishedRecipeTypes.PINK_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("pink_dye_blowing")), GarnishedFluids.PINK_MASTIC_RESIN, "pink_dye_blowing"));
        localCategories.add(BlackDyeBlowingFanCategory.create(GarnishedRecipeTypes.BLACK_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("black_dye_blowing")), GarnishedFluids.BLACK_MASTIC_RESIN, "black_dye_blowing"));
        localCategories.add(GrayDyeBlowingFanCategory.create(GarnishedRecipeTypes.GRAY_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("gray_dye_blowing")), GarnishedFluids.GRAY_MASTIC_RESIN, "gray_dye_blowing"));
        localCategories.add(LightGrayDyeBlowingFanCategory.create(GarnishedRecipeTypes.LIGHT_GRAY_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("light_gray_dye_blowing")), GarnishedFluids.LIGHT_GRAY_MASTIC_RESIN, "light_gray_dye_blowing"));
        localCategories.add(WhiteDyeBlowingFanCategory.create(GarnishedRecipeTypes.WHITE_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("white_dye_blowing")), GarnishedFluids.WHITE_MASTIC_RESIN, "white_dye_blowing"));
        localCategories.add(BrownDyeBlowingFanCategory.create(GarnishedRecipeTypes.BROWN_DYE_BLOWING.getType(), guiHelper, RecipeType.createRecipeHolderType((ResourceLocation)CreateGarnished.asResource("brown_dye_blowing")), GarnishedFluids.BROWN_MASTIC_RESIN, "brown_dye_blowing"));
        registration.addRecipeCategories(localCategories.toArray(new IRecipeCategory[0]));
        this.categories.clear();
        this.categories.addAll(localCategories);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerRecipes(registration);
        }
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.ENFLAMED_MANDIBLE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.enflamed_mandible.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.GHAST_TENDRIL.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.ghast_tendril.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.MOLTEN_REMNANT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.molten_remnant.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.RAW_POLAR_BEAR_MEAT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.polar_bear_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.POLAR_BEAR_HIDE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.polar_bear_hide.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.NUMBING_PARCHMENT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.stray_parchment.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.RAW_TENEBROUS_MEAT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.tenebrous_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.TUSK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.tusk.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.IRATE_TUSK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.irate_tusk.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.DIMMED_SCALE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.ender_scale.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.PRELIMINARY_NUCLEUS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.endermite_heart.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.MEAT_SCRAPS.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.ravager_meat.information")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)GarnishedItems.VEX_WING.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.garnished.vex_wing.information")});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories(registration);
        registration.addRecipeCategories((IRecipeCategory[])this.categories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.getJeiHelpers().getRecipeType(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"sandpaper_polishing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)GarnishedItems.POLAR_HIDE_SCRATCH_PAPER.get()), new RecipeType[]{type}));
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerCatalysts(registration);
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException();
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft);
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level);
        return level.getRecipeManager();
    }
}

