/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.recipe;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.dakotapride.garnished.registry.GarnishedDamageSource;
import net.dakotapride.garnished.registry.GarnishedFluids;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.dakotapride.garnished.registry.ZultaniteStoneTypes;
import net.dakotapride.garnished.registry.recipe.GarnishedRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GarnishedFanProcessing {
    public static final DeferredRegister<FanProcessingType> FAN_PROCESSING_TYPES = DeferredRegister.create((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (String)"garnished");
    public static final DeferredHolder<FanProcessingType, FreezingType> FREEZING = GarnishedFanProcessing.register("freezing", new FreezingType());
    public static final DeferredHolder<FanProcessingType, RedDyeBlowingFanProcessingType> RED_DYE_BLOWING = GarnishedFanProcessing.register("red_dye_blowing", new RedDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, OrangeDyeBlowingFanProcessingType> ORANGE_DYE_BLOWING = GarnishedFanProcessing.register("orange_dye_blowing", new OrangeDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, YellowDyeBlowingFanProcessingType> YELLOW_DYE_BLOWING = GarnishedFanProcessing.register("yellow_dye_blowing", new YellowDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, GreenDyeBlowingFanProcessingType> GREEN_DYE_BLOWING = GarnishedFanProcessing.register("green_dye_blowing", new GreenDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, LimeDyeBlowingFanProcessingType> LIME_DYE_BLOWING = GarnishedFanProcessing.register("lime_dye_blowing", new LimeDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, BlueDyeBlowingFanProcessingType> BLUE_DYE_BLOWING = GarnishedFanProcessing.register("blue_dye_blowing", new BlueDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, LightBlueDyeBlowingFanProcessingType> LIGHT_BLUE_DYE_BLOWING = GarnishedFanProcessing.register("light_blue_dye_blowing", new LightBlueDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, CyanDyeBlowingFanProcessingType> CYAN_DYE_BLOWING = GarnishedFanProcessing.register("cyan_dye_blowing", new CyanDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, PurpleDyeBlowingFanProcessingType> PURPLE_DYE_BLOWING = GarnishedFanProcessing.register("purple_dye_blowing", new PurpleDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, MagentaDyeBlowingFanProcessingType> MAGENTA_DYE_BLOWING = GarnishedFanProcessing.register("magenta_dye_blowing", new MagentaDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, PinkDyeBlowingFanProcessingType> PINK_DYE_BLOWING = GarnishedFanProcessing.register("pink_dye_blowing", new PinkDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, BlackDyeBlowingFanProcessingType> BLACK_DYE_BLOWING = GarnishedFanProcessing.register("black_dye_blowing", new BlackDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, GrayDyeBlowingFanProcessingType> GRAY_DYE_BLOWING = GarnishedFanProcessing.register("gray_dye_blowing", new GrayDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, LightGrayDyeBlowingFanProcessingType> LIGHT_GRAY_DYE_BLOWING = GarnishedFanProcessing.register("light_gray_dye_blowing", new LightGrayDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, WhiteDyeBlowingFanProcessingType> WHITE_DYE_BLOWING = GarnishedFanProcessing.register("white_dye_blowing", new WhiteDyeBlowingFanProcessingType());
    public static final DeferredHolder<FanProcessingType, BrownDyeBlowingFanProcessingType> BROWN_DYE_BLOWING = GarnishedFanProcessing.register("brown_dye_blowing", new BrownDyeBlowingFanProcessingType());

    private static <T extends FanProcessingType> DeferredHolder<FanProcessingType, T> register(String id, T type) {
        return FAN_PROCESSING_TYPES.register(id, () -> type);
    }

    public static void register(IEventBus bus) {
        FAN_PROCESSING_TYPES.register(bus);
    }

    public static class FreezingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is(GarnishedTags.FAN_FREEZING_PROCESSING_FLUID_TAG)) {
                return true;
            }
            BlockState blockState = level.getBlockState(pos);
            return blockState.is(GarnishedTags.FAN_FREEZING_PROCESSING_TAG);
        }

        public int getPriority() {
            return 2000;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.FREEZING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.nextFloat()));
            particleAccess.setAlpha(1.0f);
            if (random.nextFloat() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.canFreeze()) {
                entity.setTicksFrozen(120);
                entity.hurt(entity.damageSources().source(GarnishedDamageSource.FAN_FREEZING), 2.0f);
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class RedDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.RED_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2100;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.RED_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.RED_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)9312537, (int)12337987, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.RED.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class OrangeDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.ORANGE_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.ORANGE_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2200;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.ORANGE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.ORANGE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)10835502, (int)12024122, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.ORANGE.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class YellowDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.YELLOW_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.YELLOW_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2300;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.YELLOW_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.YELLOW_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)11700277, (int)13416273, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.YELLOW.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class GreenDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.GREEN_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.GREEN_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2400;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.GREEN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.GREEN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)4427305, (int)8567625, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.GREEN.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class LimeDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIME_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIME_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2500;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIME_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIME_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)3655238, (int)7529824, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.LIME.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class BlueDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BLUE_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BLUE_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2600;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BLUE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BLUE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)2513791, (int)5021869, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.BLUE.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class LightBlueDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIGHT_BLUE_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIGHT_BLUE_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2700;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIGHT_BLUE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIGHT_BLUE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)3967406, (int)5820117, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.LIGHT_BLUE.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class CyanDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.CYAN_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.CYAN_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2800;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.CYAN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.CYAN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)4098684, (int)6801056, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.CYAN.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class PurpleDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.PURPLE_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.PURPLE_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 2900;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.PURPLE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.PURPLE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)5711001, (int)8468914, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.PURPLE.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class MagentaDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.MAGENTA_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.MAGENTA_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3000;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.MAGENTA_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.MAGENTA_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)10563526, (int)13846235, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.MAGENTA.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class PinkDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.PINK_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.PINK_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3100;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.PINK_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.PINK_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)13193357, (int)14904511, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.PINK.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class BlackDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BLACK_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BLACK_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3200;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BLACK_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BLACK_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)398878, (int)1060659, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.BLACK.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class GrayDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.GRAY_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.GRAY_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3300;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.GRAY_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.GRAY_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0x2D333D, (int)4673878, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.GRAY.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class LightGrayDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIGHT_GRAY_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.LIGHT_GRAY_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3400;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIGHT_GRAY_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.LIGHT_GRAY_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)7702435, (int)10138044, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.LIGHT_GRAY.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class WhiteDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.WHITE_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.WHITE_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3500;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.WHITE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.WHITE_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)12633312, (int)15133172, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.WHITE.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }

    public static class BrownDyeBlowingFanProcessingType
    implements FanProcessingType {
        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.getFluidState(pos);
            return fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BROWN_MASTIC_RESIN.get()).getSource()) || fluidState.is(((BaseFlowingFluid.Flowing)GarnishedFluids.BROWN_MASTIC_RESIN.get()).getFlowing());
        }

        public int getPriority() {
            return 3600;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return false;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BROWN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            if (stack.isEmpty()) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(GarnishedRecipeTypes.BROWN_DYE_BLOWING.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value())).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, pos.x, pos.y + 0.25, pos.z, 0.0, 0.0625, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)6374194, (int)8543043, (float)random.nextFloat()));
            particleAccess.setAlpha(0.5f);
            if (random.nextFloat() < 0.0625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)ZultaniteStoneTypes.BROWN.getSlimeLikeBlock().get()).defaultBlockState()), 0.25f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.isClientSide) {
                return;
            }
            if (entity.isOnFire()) {
                entity.extinguishFire();
            }
        }
    }
}

