/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet.tier.integrated;

import java.util.List;
import net.dakotapride.garnished.GarnishedUtils;
import net.dakotapride.garnished.item.hatchet.IntegratedHatchetToolItem;
import net.dakotapride.garnished.item.hatchet.IntegratedMaterials;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceHatchetToolItem
extends IntegratedHatchetToolItem {
    public ExperienceHatchetToolItem(Item.Properties properties) {
        super(GarnishedUtils.stuffAndAdditions(), IntegratedMaterials.EXPERIENCE, properties);
    }

    public boolean mineBlock(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState blockstate, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        ExperienceHatchetToolItem.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        return super.mineBlock(itemstack, world, blockstate, pos, entity);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        ExperienceHatchetToolItem.execute((LevelAccessor)target.level(), (Entity)target);
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext ctx, List<Component> components, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)"\u00a78Hold [\u00a7fShift\u00a78] for Summary"));
            components.add((Component)Component.literal((String)" "));
            components.add((Component)Component.literal((String)"\u00a75Use this tool gradually crumbles"));
            components.add((Component)Component.literal((String)"\u00a75it and if you are lucky, the tool"));
            components.add((Component)Component.literal((String)"\u00a75will spawn \u00a7dxp orbs"));
        } else {
            components.add((Component)Component.literal((String)"\u00a78Hold [\u00a77Shift\u00a78] for Summary"));
        }
        super.appendHoverText(stack, ctx, components, tooltipFlag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        if (Math.random() < 0.1 && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.addFreshEntity((Entity)new ExperienceOrb((Level)level, x + 0.5, y + 0.5, z + 0.5, 1));
        }
    }

    public static void execute(LevelAccessor world, Entity entity) {
        if (entity != null && Math.random() < 0.1 && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.addFreshEntity((Entity)new ExperienceOrb((Level)level, entity.getX(), entity.getY(), entity.getZ(), 1));
        }
    }
}

