/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet;

import java.util.function.Supplier;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public enum IntegratedMaterials implements Tier
{
    ZINC((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 250, 7.0f, 7.0f, 11, () -> Ingredient.of(GarnishedTags.ZINC_INGOTS)),
    COPPER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 131, 5.0f, 5.0f, 11, () -> Ingredient.of(GarnishedTags.COPPER_INGOTS)),
    BRASS((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 450, 8.0f, 7.0f, 14, () -> Ingredient.of(GarnishedTags.BRASS_INGOTS)),
    ROSE_QUARTZ((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1644, 9.0f, 7.0f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})),
    EXPERIENCE((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 270, 7.0f, 5.0f, 800, () -> Ingredient.of(GarnishedTags.EXPERIENCE_REPAIRABLE_ITEMS)),
    BLAZING((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 450, 12.0f, 6.5f, 2, () -> Ingredient.of(GarnishedTags.BLAZING_REPAIRABLE_ITEMS)),
    WARDEN((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 2519, 10.0f, 5.0f, 18, () -> Ingredient.of(GarnishedTags.WARDEN_REPAIRABLE_ITEMS)),
    ROSE_GOLD((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 900, 9.0f, 2.0f, 17, () -> Ingredient.of(GarnishedTags.COPPER_INGOTS)),
    GILDED_NETHERITE((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 2031, 10.0f, 2.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})),
    NETHER_QUARTZ((TagKey<Block>)Tiers.IRON.getIncorrectBlocksForDrops(), Tiers.IRON.getUses(), Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus(), Tiers.IRON.getEnchantmentValue(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ})),
    CERTUS_QUARTZ((TagKey<Block>)Tiers.IRON.getIncorrectBlocksForDrops(), Tiers.IRON.getUses(), Tiers.IRON.getSpeed(), Tiers.IRON.getAttackDamageBonus(), Tiers.IRON.getEnchantmentValue(), () -> Ingredient.of(GarnishedTags.CERTUS_QUARTZ)),
    FLUIX((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, Tiers.IRON.getUses() * 3, Tiers.IRON.getSpeed() * 1.2f, Tiers.IRON.getAttackDamageBonus() * 1.2f, Tiers.IRON.getEnchantmentValue(), () -> Ingredient.of(GarnishedTags.FLUIX_CRYSTALS));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private IntegratedMaterials(TagKey<Block> incorrectBlocksForDrops, int pUses, float pSpeed, float pDamage, int pEnchantmentValue, Supplier<Ingredient> pRepairIngredient) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.uses = pUses;
        this.speed = pSpeed;
        this.damage = pDamage;
        this.enchantmentValue = pEnchantmentValue;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return (Ingredient)this.repairIngredient.get();
    }
}

