/*
 * Decompiled with CFR 0.152.
 */
package com.clickadv.mixin;

import com.clickadv.ClickAdvancements;
import com.clickadv.config.CommonConfiguration;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerAdvancements.class})
public class PlayerAdvancementsMixin {
    @Shadow
    private ServerPlayer player;

    @Inject(method={"award"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerAdvancements;markForVisibilityUpdate(Lnet/minecraft/advancements/AdvancementHolder;)V")})
    public void onGrant(AdvancementHolder advancementHolder, String string, CallbackInfoReturnable<Boolean> cir) {
        Advancement advancement = advancementHolder.value();
        if (!(!advancement.display().isPresent() || ((DisplayInfo)advancement.display().get()).shouldAnnounceChat() && this.player.level().getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS))) {
            if (!(this.player instanceof ServerPlayer)) {
                return;
            }
            if (this.player.getClass() != ServerPlayer.class && this.player.connection == null) {
                ClickAdvancements.LOGGER.error("Trying to award advancement to a fake player which does not have a connection either, this is a bug in another mod and should not happen. printing trace: Entity:" + String.valueOf(this.player), (Throwable)new Exception());
                return;
            }
            if (((CommonConfiguration)ClickAdvancements.config.getCommonConfig()).showAllInLocalChat && advancement.parent().isPresent() && advancement.display().isPresent() && ((DisplayInfo)advancement.display().get()).shouldShowToast() || advancement.display().isPresent() && ((DisplayInfo)advancement.display().get()).shouldAnnounceChat()) {
                MutableComponent chatComponent = ((DisplayInfo)advancement.display().get()).getType().createAnnouncement(advancementHolder, this.player);
                if (chatComponent == null || chatComponent.getString().contains("recipe")) {
                    return;
                }
                MutableComponent desc = (MutableComponent)((DisplayInfo)advancement.display().get()).getDescription();
                int lenght = chatComponent.getString().length();
                if (desc != null) {
                    chatComponent.append((Component)Component.literal((String)" ")).append((Component)desc.setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)));
                    lenght += desc.getString().length();
                }
                if (lenght > 120 && (chatComponent = ((DisplayInfo)advancement.display().get()).getType().createAnnouncement(advancementHolder, this.player)).getString().length() > 120) {
                    return;
                }
                this.player.displayClientMessage((Component)chatComponent, false);
            }
        }
    }
}

