/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RibbitFishGoal
extends Goal {
    private static final float REQUIRED_DISTANCE_TO_DRY_POS = 0.2f;
    private final RibbitEntity ribbit;
    private final double range;
    private final int minRequiredFishTicks;
    private final int maxRequiredFishTicks;
    private final float speedModifier;
    private int requiredFishTicks;
    private int ticksFishing;
    private BlockPos waterPos;
    private Vec3 dryPos;

    public RibbitFishGoal(RibbitEntity ribbit, double range, float speedModifier, int minRequiredFishTicks, int maxRequiredFishTicks) {
        this.ribbit = ribbit;
        this.range = range;
        this.speedModifier = speedModifier;
        this.minRequiredFishTicks = minRequiredFishTicks;
        this.maxRequiredFishTicks = maxRequiredFishTicks;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void start() {
        this.requiredFishTicks = this.ribbit.getRandom().nextInt(this.minRequiredFishTicks, this.maxRequiredFishTicks);
        this.ticksFishing = 0;
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().moveTo(this.dryPos.x(), this.dryPos.y(), this.dryPos.z(), (double)(this.speedModifier * waterModifier));
    }

    public void stop() {
        this.waterPos = null;
        this.dryPos = null;
        this.ticksFishing = 0;
        this.ribbit.setFishing(false);
    }

    public boolean isInterruptable() {
        return this.ticksFishing >= this.requiredFishTicks;
    }

    public boolean canUse() {
        if (this.ribbit.level().isNight()) {
            return false;
        }
        Optional waterPos = BlockPos.findClosestMatch((BlockPos)this.ribbit.getOnPos(), (int)((int)this.range), (int)5, blockpos -> this.ribbit.level().getFluidState(blockpos).is(FluidTags.WATER) && this.ribbit.level().getBlockState(blockpos.above()).is(Blocks.AIR));
        this.dryPos = null;
        if (waterPos.isPresent()) {
            this.waterPos = (BlockPos)waterPos.get();
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(this.ribbit.getRandom())) {
                BlockPos testedDryPos = this.waterPos.relative(dir);
                if (!this.ribbit.level().getBlockState(testedDryPos.above()).is(Blocks.AIR) || !Block.isFaceFull((VoxelShape)this.ribbit.level().getBlockState(testedDryPos).getCollisionShape((BlockGetter)this.ribbit.level(), testedDryPos), (Direction)Direction.UP)) continue;
                Vec3 dryPosCenter = new Vec3((double)testedDryPos.getX() + 0.5, (double)testedDryPos.getY() + 1.0, (double)testedDryPos.getZ() + 0.5);
                this.dryPos = dryPosCenter.add((double)(-dir.getStepX()) * 0.25, 0.0, (double)(-dir.getStepZ()) * 0.25);
                break;
            }
        } else {
            return false;
        }
        if (this.dryPos == null) {
            return false;
        }
        return this.ribbit.level().isDay();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canContinueToUse() {
        Iterable nearbyPositions = BlockPos.betweenClosed((int)Mth.floor((double)(this.ribbit.getX() - 1.5)), (int)Mth.floor((double)(this.ribbit.getY() - 1.5)), (int)Mth.floor((double)(this.ribbit.getZ() - 1.5)), (int)Mth.floor((double)(this.ribbit.getX() + 1.5)), (int)this.ribbit.getBlockY(), (int)Mth.floor((double)(this.ribbit.getZ() + 1.5)));
        boolean waterNearby = false;
        for (BlockPos nearbyPos : nearbyPositions) {
            if (!this.ribbit.level().getFluidState(nearbyPos).is(FluidTags.WATER)) continue;
            waterNearby = true;
            break;
        }
        return this.ribbit.distanceToSqr(this.dryPos) >= 0.04000000283122063 || waterNearby;
    }

    public void tick() {
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().setSpeedModifier((double)(this.speedModifier * waterModifier));
        if (this.ribbit.distanceToSqr(this.dryPos) <= 0.04000000283122063) {
            ++this.ticksFishing;
            this.ribbit.setFishing(true);
            this.ribbit.getLookControl().setLookAt((double)((float)this.waterPos.getX() + 0.5f), this.ribbit.getEyeY(), (double)((float)this.waterPos.getZ() + 0.5f));
        } else if (this.ribbit.distanceToSqr(this.dryPos) < 1.0) {
            this.ribbit.setFishing(false);
            this.ribbit.getMoveControl().setWantedPosition(this.dryPos.x(), this.dryPos.y(), this.dryPos.z(), (double)(this.speedModifier * waterModifier));
        } else {
            this.ribbit.setFishing(false);
            this.ribbit.getNavigation().moveTo(this.dryPos.x(), this.dryPos.y(), this.dryPos.z(), (double)(this.speedModifier * waterModifier));
        }
    }
}

