/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.data.RibbitUmbrellaType;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitProfessionModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitUmbrellaTypeModule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RibbitData {
    public static final Codec<RibbitData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("profession").forGetter(data -> data.profession.getId()), (App)ResourceLocation.CODEC.fieldOf("umbrella").forGetter(data -> data.umbrellaType.getId()), (App)ResourceLocation.CODEC.fieldOf("instrument").forGetter(data -> data.instrument.getId())).apply((Applicative)instance, instance.stable(RibbitData::new)));
    public static final StreamCodec<FriendlyByteBuf, RibbitData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, data -> data.profession.getId(), (StreamCodec)ResourceLocation.STREAM_CODEC, data -> data.umbrellaType.getId(), (StreamCodec)ResourceLocation.STREAM_CODEC, data -> data.instrument.getId(), RibbitData::new);
    private RibbitProfession profession;
    private final RibbitUmbrellaType umbrellaType;
    private RibbitInstrument instrument;

    private RibbitData(ResourceLocation professionId, ResourceLocation umbrellaTypeId, ResourceLocation instrumentId) {
        this.profession = RibbitProfessionModule.getProfession(professionId);
        this.umbrellaType = RibbitUmbrellaTypeModule.getUmbrellaType(umbrellaTypeId);
        this.instrument = RibbitInstrumentModule.getInstrument(instrumentId);
    }

    public RibbitData(RibbitProfession profession, RibbitUmbrellaType umbrellaType, RibbitInstrument instrument) {
        this.profession = profession;
        this.umbrellaType = umbrellaType;
        this.instrument = instrument;
    }

    public RibbitData(FriendlyByteBuf buf) {
        this.profession = RibbitProfessionModule.getProfession(buf.readResourceLocation());
        this.umbrellaType = RibbitUmbrellaTypeModule.getUmbrellaType(buf.readResourceLocation());
        this.instrument = RibbitInstrumentModule.getInstrument(buf.readResourceLocation());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.getProfession().getId());
        buf.writeResourceLocation(this.getUmbrellaType().getId());
        buf.writeResourceLocation(this.getInstrument().getId());
    }

    public RibbitProfession getProfession() {
        return this.profession;
    }

    public void setProfession(RibbitProfession profession) {
        this.profession = profession;
    }

    public RibbitUmbrellaType getUmbrellaType() {
        return this.umbrellaType;
    }

    public RibbitInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(@Nullable RibbitInstrument instrument) {
        this.instrument = instrument;
    }
}

