/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.supporters;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.supporters.SupportersJSON;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class SupportersListClient {
    private static final Set<UUID> playersWithSupporterHat = new HashSet<UUID>();

    public static void toggleSupporterHat(UUID playerUUID, boolean enabled) {
        if (enabled) {
            if (!Services.PLATFORM.isDevelopmentEnvironment() && !SupportersJSON.get().isSupporter(playerUUID)) {
                RibbitsCommon.LOGGER.error("Player {} attempted to enable supporter hat without being a supporter!", (Object)playerUUID);
                return;
            }
            playersWithSupporterHat.add(playerUUID);
        } else {
            playersWithSupporterHat.remove(playerUUID);
        }
    }

    public static boolean isPlayerSupporterHatEnabled(UUID playerUUID) {
        return playersWithSupporterHat.contains(playerUUID);
    }

    public static void clear() {
        playersWithSupporterHat.clear();
    }
}

