/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class PurityWeightsRegistry
extends DynamicRegistry<PurityWeights> {
    public static final PurityWeightsRegistry INSTANCE = new PurityWeightsRegistry();
    public static final ResourceLocation TARGET_FILE = Apotheosis.loc("weights");
    private static final Map<Purity, TieredWeights> ERRORED = Map.of(Purity.CRACKED, TieredWeights.forAllTiers(1, 0.0f), Purity.CHIPPED, TieredWeights.EMPTY, Purity.FLAWED, TieredWeights.EMPTY, Purity.NORMAL, TieredWeights.EMPTY, Purity.FLAWLESS, TieredWeights.EMPTY, Purity.PERFECT, TieredWeights.EMPTY);
    private Map<Purity, TieredWeights> parsedWeights = Map.of();

    public PurityWeightsRegistry() {
        super(Apotheosis.LOGGER, "purity_weights", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("purity_weights"), PurityWeights.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.parsedWeights = Map.of();
    }

    protected void onReload() {
        super.onReload();
        if (this.registry.size() > 1) {
            this.logger.error("Additional purity weights files have been loaded. Only {} will be parsed.", (Object)TARGET_FILE);
        }
        if (this.registry.containsKey((Object)TARGET_FILE)) {
            PurityWeights weights = (PurityWeights)this.registry.get((Object)TARGET_FILE);
            HashMap<Purity, TieredWeights> weightMap = new HashMap<Purity, TieredWeights>();
            for (Purity p : Purity.ALL_PURITIES) {
                TieredWeights.Builder builder = TieredWeights.builder();
                for (WorldTier tier : WorldTier.values()) {
                    Map tierMap = weights.weights().getOrDefault((Object)tier, Map.of());
                    TieredWeights.Weight weight = tierMap.getOrDefault(p, TieredWeights.Weight.ZERO);
                    builder.with(tier, weight);
                }
                weightMap.put(p, builder.build());
            }
            this.parsedWeights = Collections.unmodifiableMap(weightMap);
        } else {
            this.logger.error("Purity weights file {} not loaded! All purity weights will be set to zero, meaning only cracked gems will spawn.", (Object)TARGET_FILE);
        }
    }

    public static Map<Purity, TieredWeights> getWeights() {
        return PurityWeightsRegistry.INSTANCE.parsedWeights.isEmpty() ? ERRORED : PurityWeightsRegistry.INSTANCE.parsedWeights;
    }

    public record PurityWeights(Map<WorldTier, Map<Purity, TieredWeights.Weight>> weights) implements CodecProvider<PurityWeights>
    {
        public static final Codec<PurityWeights> CODEC = WorldTier.mapCodec(Purity.mapCodec(TieredWeights.Weight.CODEC.codec()).codec()).fieldOf("weights").xmap(PurityWeights::new, PurityWeights::weights).codec();

        public Codec<? extends PurityWeights> getCodec() {
            return CODEC;
        }
    }
}

