/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.socket.gem.ExtraGemBonusRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredDynamicRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GemRegistry
extends TieredDynamicRegistry<Gem> {
    public static final GemRegistry INSTANCE = new GemRegistry();

    public GemRegistry() {
        super(Apotheosis.LOGGER, "gems", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("gem"), Gem.CODEC);
    }

    protected void validateItem(ResourceLocation key, Gem item) {
        super.validateItem(key, (CodecProvider)item);
        for (Purity p : Purity.values()) {
            if (!p.isAtLeast(item.getMinPurity())) continue;
            boolean atLeastOne = false;
            for (GemBonus bonus : item.bonuses) {
                if (!bonus.supports(p)) continue;
                atLeastOne = true;
            }
            Preconditions.checkArgument((boolean)atLeastOne, (String)"No bonuses provided for supported purity %s. At least one bonus must be provided, or the minimum purity should be raised.", (Object)p.getName());
        }
    }

    protected void onReload() {
        super.onReload();
        for (Gem gem : this.getValues()) {
            DynamicHolder holder = this.holder(gem);
            for (ExtraGemBonusRegistry.ExtraGemBonus extraBonus : ExtraGemBonusRegistry.getBonusesFor((DynamicHolder<Gem>)holder)) {
                for (GemBonus bonus : extraBonus.bonuses()) {
                    try {
                        gem.appendExtraBonus(bonus);
                    }
                    catch (Exception ex) {
                        ResourceLocation extraBonusKey = ExtraGemBonusRegistry.INSTANCE.getKey(extraBonus);
                        this.logger.warn("Failed to apply extra gem bonus for class {} to gem {}.", (Object)bonus.getGemClass().key(), (Object)holder.getId());
                        this.logger.warn("Exception while applying ExtraGemBonus %s: ".formatted(extraBonusKey), (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public Gem getRandomItem(GenContext ctx) {
        return (Gem)this.getRandomItem(ctx, Constraints.eval(ctx));
    }

    @Deprecated
    public static ItemStack createGemStack(Gem gem, Purity purity) {
        return gem.toStack(purity);
    }

    public static ItemStack createRandomGemStack(GenContext ctx) {
        Gem gem = INSTANCE.getRandomItem(ctx);
        if (gem == null) {
            return ItemStack.EMPTY;
        }
        Purity purity = Purity.random(ctx);
        return gem.toStack(purity);
    }
}

