/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Elite;
import dev.shadowsoffire.apotheosis.mobs.util.SpawnCondition;
import dev.shadowsoffire.apotheosis.mobs.util.SurfaceType;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.StepFunction;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class EliteProvider
extends DynamicRegistryProvider<Elite> {
    public static final int DEFAULT_WEIGHT = 100;
    public static final float DEFAULT_QUALITY = 0.1f;

    public EliteProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)EliteRegistry.INSTANCE);
    }

    public String getName() {
        return "Apothic Elites";
    }

    public void generate() {
        this.addBoss("overworld/craig", b -> b.chance(0.005f).entities(EntityType.GOAT).basicData(c -> c.name((Component)Component.literal((String)"Craig the Eternal").withStyle(s -> s.withColor((TextColor)GradientColor.RAINBOW))).weights(TieredWeights.onlyFor(WorldTier.PINNACLE, 100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).exclusion(EliteProvider.excludedSpawnTypes(MobSpawnType.SPAWN_EGG)).gearSets(WorldTier.PINNACLE, "#pinnacle_melee").nbt(t -> t.putBoolean("IsScreamingGoat", true)).nbt(t -> t.putBoolean("HasLeftHorn", true)).nbt(t -> t.putBoolean("HasRightHorn", true)).support(s -> s.entity((EntityType<? extends Mob>)EntityType.SHEEP).nbt(t -> t.putString("CustomName", "jeb_")))).stats(c -> c.enchantChance(1.0f).enchLevels(100, 100).effect(1.0f, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE).effect(1.0f, (Holder<MobEffect>)MobEffects.GLOWING).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)4096.0f)).modifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 4.0f, 10.0f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)1.0f)).modifier((Holder<Attribute>)Attributes.SCALE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)3.0f))));
        this.addBoss("overworld/honeyed_archer", b -> b.chance(0.008f).entities(EntityType.SKELETON, EntityType.STRAY, EntityType.BOGGED).affixes(0.25f, Set.of()).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"Honeyed Archer")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).exclusion(EliteProvider.excludedSpawnTypes(MobSpawnType.SPAWN_EGG, MobSpawnType.SPAWNER, MobSpawnType.MOB_SUMMONED)).exclusion(new SpawnCondition.SurfaceTypeCondition(SurfaceType.NEEDS_SURFACE)).mount(m -> m.entity((EntityType<? extends Mob>)EntityType.BEE).nbt(t -> t.putInt("CannotEnterHiveTicks", 999999)).nbt(t -> t.putInt("AngerTime", 99999999)))).stats(c -> c.enchantChance(0.25f).enchLevels(20, 12).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 10.0f, 20.0f).modifier((Holder<Attribute>)ALObjects.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.25f, 0.35f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f))));
        this.addBoss("overworld/undead_knight", b -> b.chance(0.01f).entities(EntityType.SKELETON, EntityType.STRAY, EntityType.BOGGED).affixes(0.35f, Set.of()).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"Undead Knight")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.OVERWORLD)).exclusion(EliteProvider.excludedSpawnTypes(MobSpawnType.SPAWN_EGG, MobSpawnType.SPAWNER, MobSpawnType.MOB_SUMMONED)).exclusion(new SpawnCondition.SurfaceTypeCondition(SurfaceType.NEEDS_SURFACE)).mount(m -> m.entity((EntityType<? extends Mob>)EntityType.SKELETON_HORSE).nbt(EliteProvider.skeletonHorseNbt()))).stats(c -> c.enchantChance(0.25f).enchLevels(20, 12).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 10.0f, 30.0f).modifier((Holder<Attribute>)ALObjects.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.3f, 0.5f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, StepFunction.constant((float)0.5f))));
        this.addBoss("the_nether/withering_archer", b -> b.chance(0.02f).entities(EntityType.WITHER_SKELETON, EntityType.SKELETON).affixes(0.45f, Set.of()).basicData(c -> InvaderProvider.rangedGear(c).name((Component)Component.literal((String)"Withering Archer")).weights(TieredWeights.forTiersAbove(WorldTier.FRONTIER, 100, 0.1f)).constraints(Constraints.forDimension((ResourceKey<Level>)Level.NETHER)).exclusion(EliteProvider.excludedSpawnTypes(MobSpawnType.SPAWN_EGG, MobSpawnType.SPAWNER, MobSpawnType.MOB_SUMMONED)).nbt(EliteProvider.witherCloud())).stats(c -> c.enchantChance(0.25f).enchLevels(20, 12).modifier((Holder<Attribute>)Attributes.MAX_HEALTH, AttributeModifier.Operation.ADD_VALUE, 20.0f, 20.0f).modifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.1f, 0.1f).modifier((Holder<Attribute>)ALObjects.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.25f, 0.25f).modifier((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, AttributeModifier.Operation.ADD_VALUE, 0.5f, 0.5f)));
    }

    private static CompoundTag skeletonHorseNbt() {
        String rawNbt = "{\n    \"NeoForgeData\": {\n        \"apoth.burns_in_sun\": 1\n    },\n    \"Tame\": 1,\n    \"attributes\": [\n        {\n            \"base\": 0.3,\n            \"id\": \"generic.movement_speed\"\n        },\n        {\n            \"base\": 0.5,\n            \"id\": \"generic.knockback_resistance\"\n        }\n    ]\n}\n";
        try {
            return TagParser.parseTag((String)rawNbt);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static CompoundTag witherCloud() {
        String rawNbt = "{\n    \"Passengers\": [{\n        \"id\": \"minecraft:area_effect_cloud\",\n        \"potion_contents\": {\n            \"potion\": \"apothic_attributes:wither\"\n        },\n        \"Duration\": 200000,\n        \"Radius\": 2.5,\n        \"ReapplicationDelay\": 20,\n        \"Particle\": {\n            \"type\":\"entity_effect\",\n            \"color\": 0\n        },\n        \"WaitTime\": 0\n    }]\n}\n";
        try {
            return TagParser.parseTag((String)rawNbt);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void addBoss(String name, UnaryOperator<Elite.Builder> builder) {
        this.add(Apotheosis.loc(name), ((Elite.Builder)builder.apply(Elite.builder())).build());
    }

    private static SpawnCondition excludedSpawnTypes(MobSpawnType ... types) {
        return new SpawnCondition.NotCondition(new SpawnCondition.SpawnTypeCondition(ApothMiscUtil.linkedSet(types)));
    }
}

