/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.twilight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.attachments.BonusLootTables;
import dev.shadowsoffire.apotheosis.compat.twilight.AdventureTwilightCompat;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.color.GradientColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import twilightforest.entity.monster.Redcap;

public class TreasureGoblinBonus
extends GemBonus {
    public static final Codec<TreasureGoblinBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(TreasureGoblinBonus.gemClass(), (App)Purity.mapCodec(Data.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, TreasureGoblinBonus::new));
    protected final Map<Purity, Data> values;

    public TreasureGoblinBonus(GemClass gemClass, Map<Purity, Data> values) {
        super(gemClass);
        this.values = values;
    }

    @Override
    public void doPostAttack(GemInstance inst, LivingEntity user, Entity target) {
        Data d = this.values.get(inst.purity());
        if (Affix.isOnCooldown(TreasureGoblinBonus.makeUniqueId(inst), d.cooldown, user)) {
            return;
        }
        if (user.getRandom().nextFloat() <= d.chance) {
            Redcap goblin = (Redcap)AdventureTwilightCompat.REDCAP.get().create(user.level());
            goblin.setData(Apoth.Attachments.BONUS_LOOT_TABLES, (Object)new BonusLootTables(List.of(Apoth.LootTables.TREASURE_GOBLIN)));
            goblin.getPersistentData().putBoolean("apoth.treasure_goblin", true);
            goblin.setCustomName((Component)Component.translatable((String)"name.apotheosis.treasure_goblin").withStyle(s -> s.withColor((TextColor)GradientColor.RAINBOW)));
            goblin.setCustomNameVisible(true);
            goblin.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(Apotheosis.loc("very_fast"), 0.2, AttributeModifier.Operation.ADD_VALUE));
            goblin.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(Apotheosis.loc("healmth"), 60.0, AttributeModifier.Operation.ADD_VALUE));
            goblin.setHealth(goblin.getMaxHealth());
            for (int i = 0; i < 8; ++i) {
                int x = Mth.nextInt((RandomSource)goblin.getRandom(), (int)-5, (int)5);
                int y = Mth.nextInt((RandomSource)goblin.getRandom(), (int)-1, (int)1);
                int z = Mth.nextInt((RandomSource)goblin.getRandom(), (int)-5, (int)5);
                goblin.setPos(target.position().add((double)x, (double)y, (double)z));
                if (user.level().noCollision((Entity)goblin)) break;
                if (i != 7) continue;
                goblin.setPos(target.position());
            }
            goblin.addEffect(new MobEffectInstance(MobEffects.GLOWING, 96000, 0, true, false));
            user.level().addFreshEntity((Entity)goblin);
            Affix.startCooldown(TreasureGoblinBonus.makeUniqueId(inst), user);
        }
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        Data d = this.values.get(inst.purity());
        MutableComponent cooldown = Component.translatable((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.formatTickDuration((int)d.cooldown, (float)ctx.tickRate())});
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(d.chance * 100.0f), cooldown}).withStyle(ChatFormatting.YELLOW);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected record Data(float chance, int cooldown) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(Data::chance), (App)Codec.INT.fieldOf("cooldown").forGetter(Data::cooldown)).apply((Applicative)inst, Data::new));
    }

    public static class Builder
    extends GemBonus.Builder {
        protected final Map<Purity, Data> values = new HashMap<Purity, Data>();

        public Builder value(Purity purity, float chance, int cooldown) {
            this.values.put(purity, new Data(chance, cooldown));
            return this;
        }

        @Override
        public TreasureGoblinBonus build(GemClass gClass) {
            return new TreasureGoblinBonus(gClass, this.values);
        }
    }
}

