/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.jei;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.UnnamingRecipe;
import dev.shadowsoffire.apotheosis.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.compat.jei.AddSocketsExtension;
import dev.shadowsoffire.apotheosis.compat.jei.ApothSmithingCategory;
import dev.shadowsoffire.apotheosis.compat.jei.CharmInfusionExtension;
import dev.shadowsoffire.apotheosis.compat.jei.GemCuttingCategory;
import dev.shadowsoffire.apotheosis.compat.jei.MaliceExtension;
import dev.shadowsoffire.apotheosis.compat.jei.PotionCharmExtension;
import dev.shadowsoffire.apotheosis.compat.jei.SalvagingCategory;
import dev.shadowsoffire.apotheosis.compat.jei.SizedUpgradeRecipeExtension;
import dev.shadowsoffire.apotheosis.compat.jei.UnnamingExtension;
import dev.shadowsoffire.apotheosis.compat.jei.WithdrawalExtension;
import dev.shadowsoffire.apotheosis.recipe.CharmInfusionRecipe;
import dev.shadowsoffire.apotheosis.recipe.MaliceRecipe;
import dev.shadowsoffire.apotheosis.recipe.PotionCharmRecipe;
import dev.shadowsoffire.apotheosis.socket.AddSocketsRecipe;
import dev.shadowsoffire.apotheosis.socket.WithdrawalRecipe;
import dev.shadowsoffire.apotheosis.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.UnsocketedGem;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.GemCuttingRecipe;
import dev.shadowsoffire.apotheosis.socket.gem.cutting.PurityUpgradeRecipe;
import dev.shadowsoffire.apotheosis.util.ApothSmithingRecipe;
import dev.shadowsoffire.apotheosis.util.SizedUpgradeRecipe;
import dev.shadowsoffire.apothic_enchanting.compat.InfusionRecipeCategory;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class AdventureJEIPlugin
implements IModPlugin {
    public static final RecipeType<SmithingRecipe> APO_SMITHING = RecipeType.create((String)"apotheosis", (String)"smithing", ApothSmithingRecipe.class);
    public static final RecipeType<SalvagingRecipe> SALVAGING = RecipeType.create((String)"apotheosis", (String)"salvaging", SalvagingRecipe.class);
    public static final RecipeType<GemCuttingRecipe> GEM_CUTTING = RecipeType.create((String)"apotheosis", (String)"gem_cutting", PurityUpgradeRecipe.class);

    public ResourceLocation getPluginUid() {
        return Apotheosis.loc("adventure_module");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        MutableComponent socketInfo = Component.translatable((String)"info.apotheosis.socketing");
        for (Gem gem : GemRegistry.INSTANCE.getValues()) {
            for (Purity purity : Purity.ALL_PURITIES) {
                if (!purity.isAtLeast(gem.getMinPurity())) continue;
                reg.addIngredientInfo((Object)gem.toStack(purity), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{socketInfo});
            }
        }
        reg.addIngredientInfo((Object)new ItemStack(Apoth.Items.GEM_DUST), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"info.apotheosis.gem_crushing")});
        reg.addIngredientInfo((Object)new ItemStack(Apoth.Items.SIGIL_OF_UNNAMING), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"info.apotheosis.unnaming")});
        List<SalvagingRecipe> salvagingRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(Apoth.RecipeTypes.SALVAGING).stream().sorted(Comparator.comparing(RecipeHolder::id)).map(RecipeHolder::value).toList();
        reg.addRecipes(SALVAGING, salvagingRecipes);
        reg.addRecipes(GEM_CUTTING, Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(Apoth.RecipeTypes.GEM_CUTTING).stream().map(RecipeHolder::value).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new ApothSmithingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new GemCuttingCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SMITHING_TABLE), new RecipeType[]{APO_SMITHING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Apoth.Blocks.SALVAGING_TABLE.value()), new RecipeType[]{SALVAGING});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Apoth.Blocks.GEM_CUTTING_TABLE.value()), new RecipeType[]{GEM_CUTTING});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)Apoth.Items.GEM.value(), (ISubtypeInterpreter)new GemSubtypes());
        reg.registerSubtypeInterpreter((Item)Apoth.Items.POTION_CHARM.value(), (ISubtypeInterpreter)new PotionCharmExtension.PotionCharmSubtypes());
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration reg) {
        reg.getCraftingCategory().addExtension(PotionCharmRecipe.class, (ICraftingCategoryExtension)new PotionCharmExtension());
        InfusionRecipeCategory.registerExtension(CharmInfusionRecipe.class, (InfusionRecipeCategory.Extension)new CharmInfusionExtension());
        reg.getSmithingCategory().addExtension(SizedUpgradeRecipe.class, (ISmithingCategoryExtension)new SizedUpgradeRecipeExtension());
        reg.getSmithingCategory().addExtension(AddSocketsRecipe.class, (ISmithingCategoryExtension)new AddSocketsExtension());
        reg.getSmithingCategory().addExtension(WithdrawalRecipe.class, (ISmithingCategoryExtension)new WithdrawalExtension());
        reg.getSmithingCategory().addExtension(UnnamingRecipe.class, (ISmithingCategoryExtension)new UnnamingExtension());
        reg.getSmithingCategory().addExtension(MaliceRecipe.class, (ISmithingCategoryExtension)new MaliceExtension());
    }

    static class GemSubtypes
    implements ISubtypeInterpreter<ItemStack> {
        GemSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            UnsocketedGem inst = UnsocketedGem.of(stack);
            if (!inst.isValid()) {
                return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
            }
            return String.valueOf(inst.gem().getId()) + "@" + inst.purity().getSerializedName();
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return this.apply(ingredient, context);
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return this.apply(ingredient, context);
        }
    }
}

