/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.ItemAffixes;
import dev.shadowsoffire.apotheosis.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.loot.LootController;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ReforgeCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_RARITY = RarityCommand.SUGGEST_RARITY;

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"reforge").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"rarity", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_RARITY).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            GenContext ctx = GenContext.forPlayer((Player)p);
            LootRarity rarity = (LootRarity)RarityRegistry.INSTANCE.getValue(ResourceLocationArgument.getId((CommandContext)c, (String)"rarity"));
            ItemStack stack = p.getMainHandItem();
            AffixHelper.setAffixes(stack, ItemAffixes.EMPTY);
            LootController.createLootItem(stack, rarity, ctx);
            return 0;
        })));
    }
}

