/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.DamageSourceExtension;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Set;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;

public class MagicalArrowAffix
extends Affix {
    public static final Codec<MagicalArrowAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(MagicalArrowAffix.affixDef(), (App)PlaceboCodecs.setOf(LootRarity.CODEC).fieldOf("rarities").forGetter(a -> a.rarities)).apply((Applicative)inst, MagicalArrowAffix::new));
    protected Set<LootRarity> rarities;

    public MagicalArrowAffix(AffixDefinition def, Set<LootRarity> rarities) {
        super(def);
        this.rarities = rarities;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isRanged() && this.rarities.contains(rarity);
    }

    public static void modifyIncomingDamageTags(EntityInvulnerabilityCheckEvent e) {
        AbstractArrow arrow;
        Entity entity = e.getSource().getDirectEntity();
        if (entity instanceof AbstractArrow && AffixHelper.streamAffixes((Projectile)(arrow = (AbstractArrow)entity)).anyMatch(a -> a.getAffix() instanceof MagicalArrowAffix)) {
            DamageSourceExtension ext = (DamageSourceExtension)e.getSource();
            ext.addTag((TagKey<DamageType>)Tags.DamageTypes.IS_MAGIC);
            ext.addTag((TagKey<DamageType>)DamageTypeTags.BYPASSES_ARMOR);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

