/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.DoubleConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollbarWidget
extends AbstractWidget {
    private static final int SCROLLER_HEIGHT = 15;
    private static final int ANIMATION_SCROLL_DURATION_IN_TICKS = 10;
    private static final double ANIMATION_SCROLL_HEIGHT_IN_PIXELS = 30.0;
    private final boolean smoothScrolling = Platform.INSTANCE.getConfig().isSmoothScrolling();
    private final Type type;
    private double offset;
    private double maxOffset;
    private boolean enabled = true;
    private boolean clicked;
    private int animationScrollDirection = 0;
    private double animationStartOffset;
    private double animationTickCounter;
    private int animationSpeed;
    @Nullable
    private DoubleConsumer listener;

    public ScrollbarWidget(int x, int y, Type type, int height) {
        super(x, y, type.width, height, (Component)Component.empty());
        this.type = type;
    }

    public void setListener(@Nullable DoubleConsumer listener) {
        this.listener = listener;
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private ResourceLocation getTexture() {
        if (!this.enabled) {
            return this.type.disabledTexture;
        }
        return this.clicked ? this.type.clickedTexture : this.type.texture;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isAnimatingScroll()) {
            this.updateScrollingAnimation(partialTicks);
        }
        graphics.blitSprite(this.getTexture(), this.getX(), this.getY() + (int)((float)this.offset / (float)this.maxOffset * (float)(this.height - 15)), this.type.width, 15);
    }

    private boolean isAnimatingScroll() {
        return this.animationScrollDirection != 0;
    }

    private void updateScrollingAnimation(float partialTicks) {
        double absoluteAnimationProgress = this.animationTickCounter / 10.0;
        double relativeAnimationProgress = ScrollbarWidget.easeOutQuint(absoluteAnimationProgress);
        double scrollHeight = 30.0 + (double)(this.animationSpeed + 1) * 4.0;
        double newOffset = this.animationStartOffset + relativeAnimationProgress * scrollHeight * (double)this.animationScrollDirection;
        this.setOffset(newOffset);
        this.animationTickCounter += (double)partialTicks;
        if (absoluteAnimationProgress > 1.0) {
            this.animationStartOffset = 0.0;
            this.animationScrollDirection = 0;
            this.animationTickCounter = 0.0;
            this.animationSpeed = 0;
        }
    }

    private static double easeOutQuint(double absoluteProgress) {
        return 1.0 - Math.pow(1.0 - absoluteProgress, 5.0);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        boolean inBounds;
        boolean bl = inBounds = mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX <= (double)(this.getX() + this.width) && mouseY <= (double)(this.getY() + this.height);
        if (this.clicked && inBounds) {
            this.updateOffset(mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean inBounds;
        if (!this.isActive()) {
            return false;
        }
        boolean bl = inBounds = mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX <= (double)(this.getX() + this.width) && mouseY <= (double)(this.getY() + this.height);
        if (button == 0 && inBounds) {
            this.updateOffset(mouseY);
            this.clicked = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double z, double delta) {
        if (this.enabled) {
            int scrollDirection = Math.max(Math.min(-((int)delta), 1), -1);
            if (this.smoothScrolling) {
                this.startScrollAnimation(scrollDirection);
            } else {
                this.setOffset(this.offset + (double)scrollDirection);
            }
            return true;
        }
        return false;
    }

    private void startScrollAnimation(int scrollDirection) {
        this.animationSpeed = this.isAnimatingScroll() ? ++this.animationSpeed : 0;
        this.animationStartOffset = this.offset;
        this.animationScrollDirection = scrollDirection;
        this.animationTickCounter = 0.0;
    }

    public void setMaxOffset(double maxOffset) {
        this.maxOffset = Math.max(0.0, maxOffset);
        if (this.offset > this.maxOffset) {
            this.offset = this.maxOffset;
            if (this.listener != null) {
                this.listener.accept(this.offset);
            }
        }
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = Math.min(Math.max(0.0, offset), this.maxOffset);
        if (this.listener != null) {
            this.listener.accept(this.offset);
        }
    }

    private void updateOffset(double mouseY) {
        this.setOffset(Math.floor((mouseY - (double)this.getY()) / (double)(this.height - 15) * this.maxOffset));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum Type {
        NORMAL(IdentifierUtil.createIdentifier("widget/scrollbar"), IdentifierUtil.createIdentifier("widget/scrollbar_clicked"), IdentifierUtil.createIdentifier("widget/scrollbar_disabled"), 12),
        SMALL(IdentifierUtil.createIdentifier("widget/small_scrollbar"), IdentifierUtil.createIdentifier("widget/small_scrollbar_clicked"), IdentifierUtil.createIdentifier("widget/small_scrollbar_disabled"), 7);

        private final ResourceLocation texture;
        private final ResourceLocation clickedTexture;
        private final ResourceLocation disabledTexture;
        private final int width;

        private Type(ResourceLocation texture, ResourceLocation clickedTexture, ResourceLocation disabledTexture, int width) {
            this.texture = texture;
            this.clickedTexture = clickedTexture;
            this.disabledTexture = disabledTexture;
            this.width = width;
        }
    }
}

