/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.support.resource.AbstractResourceContainerContainerAdapter;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ResourceContainerImpl
implements ResourceContainer {
    private final ResourceAmount[] slots;
    private final ItemStack[] stackRepresentations;
    private final ToLongFunction<ResourceKey> maxAmountProvider;
    private final ResourceFactory primaryResourceFactory;
    private final Set<ResourceFactory> alternativeResourceFactories;
    @Nullable
    private Runnable listener;

    public ResourceContainerImpl(int size, ToLongFunction<ResourceKey> maxAmountProvider, ResourceFactory primaryResourceFactory, Set<ResourceFactory> alternativeResourceFactories) {
        this.slots = new ResourceAmount[size];
        this.stackRepresentations = new ItemStack[size];
        this.maxAmountProvider = maxAmountProvider;
        this.primaryResourceFactory = primaryResourceFactory;
        this.alternativeResourceFactories = alternativeResourceFactories;
    }

    @Override
    public void setListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void change(int index, ItemStack stack, boolean tryAlternatives) {
        if (tryAlternatives) {
            for (ResourceFactory resourceFactory : this.alternativeResourceFactories) {
                Optional<ResourceAmount> result = resourceFactory.create(stack).map(this::respectMaxAmount);
                if (!result.isPresent()) continue;
                this.set(index, result.get());
                return;
            }
        }
        this.primaryResourceFactory.create(stack).map(this::respectMaxAmount).ifPresentOrElse(resource -> this.set(index, (ResourceAmount)resource), () -> this.remove(index));
    }

    private ResourceAmount respectMaxAmount(ResourceAmount resourceAmount) {
        long maxAmount = this.getMaxAmount(resourceAmount.resource());
        if (resourceAmount.amount() > maxAmount) {
            return new ResourceAmount(resourceAmount.resource(), maxAmount);
        }
        return resourceAmount;
    }

    @Override
    public void set(int index, ResourceAmount resourceAmount) {
        this.setSilently(index, resourceAmount);
        this.changed();
    }

    protected void setSilently(int index, ResourceAmount resourceAmount) {
        ItemStack itemStack;
        this.slots[index] = resourceAmount;
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resourceKey;
            itemStack = itemResource.toItemStack(resourceAmount.amount());
        } else {
            itemStack = null;
        }
        this.stackRepresentations[index] = itemStack;
    }

    @Override
    public boolean isValid(ResourceKey resource) {
        if (this.primaryResourceFactory.isValid(resource)) {
            return true;
        }
        for (ResourceFactory resourceFactory : this.alternativeResourceFactories) {
            if (!resourceFactory.isValid(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getAmount(int index) {
        ResourceAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return slot.amount();
    }

    @Override
    public void grow(int index, long amount) {
        CoreValidations.validateNotNegative(amount, "Amount to grow cannot be negative.");
        this.setAmount(index, this.getAmount(index) + amount);
    }

    @Override
    public void shrink(int index, long amount) {
        CoreValidations.validateNotNegative(amount, "Amount to shrink cannot be negative.");
        this.setAmount(index, this.getAmount(index) - amount);
    }

    @Override
    public void setAmount(int index, long amount) {
        ResourceAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        long newAmount = MathUtil.clamp(amount, 0L, this.getMaxAmount(slot.resource()));
        if (newAmount == 0L) {
            this.removeSilently(index);
        } else {
            this.setSilently(index, new ResourceAmount(slot.resource(), newAmount));
        }
        this.changed();
    }

    @Override
    public long getMaxAmount(ResourceKey resource) {
        return this.maxAmountProvider.applyAsLong(resource);
    }

    @Override
    public void remove(int index) {
        this.removeSilently(index);
        this.changed();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.removeSilently(i);
        }
        this.changed();
    }

    protected void removeSilently(int index) {
        this.slots[index] = null;
        this.stackRepresentations[index] = null;
    }

    @Override
    public int size() {
        return this.slots.length;
    }

    @Override
    @Nullable
    public ResourceAmount get(int index) {
        return this.slots[index];
    }

    @Override
    @Nullable
    public PlatformResourceKey getResource(int index) {
        ResourceAmount slot = this.slots[index];
        if (slot == null) {
            return null;
        }
        return (PlatformResourceKey)slot.resource();
    }

    @Override
    public ItemStack getStackRepresentation(int index) {
        ItemStack stack = this.stackRepresentations[index];
        if (stack == null) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Override
    public Set<ResourceKey> getUniqueResources() {
        HashSet<ResourceKey> result = new HashSet<ResourceKey>();
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.slots[i];
            if (slot == null) continue;
            result.add(slot.resource());
        }
        return result;
    }

    @Override
    public List<ResourceKey> getResources() {
        ArrayList<ResourceKey> result = new ArrayList<ResourceKey>();
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.slots[i];
            if (slot == null) continue;
            result.add(slot.resource());
        }
        return result;
    }

    @Override
    public CompoundTag toTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.slots[i];
            if (slot == null) continue;
            this.addToTag(tag, i, slot, provider);
        }
        return tag;
    }

    private void addToTag(CompoundTag tag, int index, ResourceAmount slot, HolderLookup.Provider provider) {
        Tag serialized = (Tag)ResourceCodecs.AMOUNT_CODEC.encode((Object)slot, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CompoundTag()).getOrThrow();
        tag.put("s" + index, serialized);
    }

    @Override
    public void fromTag(CompoundTag tag, HolderLookup.Provider provider) {
        for (int i = 0; i < this.size(); ++i) {
            String key = "s" + i;
            if (!tag.contains(key)) {
                this.removeSilently(i);
                continue;
            }
            CompoundTag item = tag.getCompound(key);
            this.fromTag(i, item, provider);
        }
    }

    private void fromTag(int index, CompoundTag tag, HolderLookup.Provider provider) {
        ResourceAmount resourceAmount = (ResourceAmount)((Pair)ResourceCodecs.AMOUNT_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow()).getFirst();
        this.setSilently(index, resourceAmount);
    }

    @Override
    public ResourceFactory getPrimaryResourceFactory() {
        return this.primaryResourceFactory;
    }

    @Override
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.alternativeResourceFactories;
    }

    protected final void changed() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public Container toItemContainer() {
        return new AbstractResourceContainerContainerAdapter(this){

            public void setChanged() {
                ResourceContainerImpl.this.changed();
            }
        };
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action) {
        CoreValidations.validateNotNull(resource, "Resource to insert must not be null.");
        CoreValidations.validateLargerThanZero(amount, "Amount to insert must be larger than zero.");
        if (!(resource instanceof PlatformResourceKey)) {
            return 0L;
        }
        PlatformResourceKey platformResource = (PlatformResourceKey)resource;
        long remainder = amount;
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.get(i);
            if (slot == null) {
                remainder -= this.insertIntoEmptySlot(i, platformResource, action, remainder);
            } else if (slot.resource().equals(resource)) {
                remainder -= this.insertIntoExistingSlot(i, platformResource, action, remainder, slot);
            }
            if (remainder == 0L) break;
        }
        return amount - remainder;
    }

    private long insertIntoEmptySlot(int slotIndex, PlatformResourceKey resource, Action action, long amount) {
        long inserted = Math.min(resource.getInterfaceExportLimit(), amount);
        if (action == Action.EXECUTE) {
            this.set(slotIndex, new ResourceAmount(resource, inserted));
        }
        return inserted;
    }

    private long insertIntoExistingSlot(int slotIndex, PlatformResourceKey resource, Action action, long amount, ResourceAmount existing) {
        long spaceRemaining = resource.getInterfaceExportLimit() - existing.amount();
        long inserted = Math.min(spaceRemaining, amount);
        if (action == Action.EXECUTE) {
            this.grow(slotIndex, inserted);
        }
        return inserted;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action) {
        CoreValidations.validateNotNull(resource, "Resource to extract must not be null.");
        CoreValidations.validateLargerThanZero(amount, "Amount to extract must be larger than zero.");
        long extracted = 0L;
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slotContents = this.get(i);
            if (slotContents == null || !resource.equals(slotContents.resource())) continue;
            long stillNeeded = amount - extracted;
            long toExtract = Math.min(slotContents.amount(), stillNeeded);
            if (action == Action.EXECUTE) {
                this.shrink(i, toExtract);
            }
            extracted += toExtract;
        }
        return extracted;
    }

    @Override
    public ResourceContainer copy() {
        ResourceContainerImpl copy = new ResourceContainerImpl(this.slots.length, this.maxAmountProvider, this.primaryResourceFactory, this.alternativeResourceFactories);
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.get(i);
            if (slot == null) continue;
            copy.set(i, slot);
        }
        return copy;
    }

    public static ResourceContainer createForFilter() {
        return ResourceContainerImpl.createForFilter(9);
    }

    public static ResourceContainer createForFilter(ResourceContainerData data) {
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(data.resources().size());
        ResourceContainerImpl.setResourceContainerData(data.resources(), resourceContainer);
        return resourceContainer;
    }

    public static ResourceContainer createForFilter(int size) {
        return new ResourceContainerImpl(size, resource -> Long.MAX_VALUE, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    public static ResourceContainer createForFilter(ResourceFactory resourceFactory) {
        return ResourceContainerImpl.createForFilter(resourceFactory, 9);
    }

    public static ResourceContainer createForFilter(ResourceFactory resourceFactory, int size) {
        return new ResourceContainerImpl(size, resource -> Long.MAX_VALUE, resourceFactory, Collections.emptySet());
    }

    public static ResourceContainer createForFilter(ResourceFactory resourceFactory, ResourceContainerData data) {
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(resourceFactory, data.resources().size());
        ResourceContainerImpl.setResourceContainerData(data.resources(), resourceContainer);
        return resourceContainer;
    }

    public static ResourceContainer createForFilter(ResourceFactory resourceFactory, List<Optional<ResourceAmount>> resources) {
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(resourceFactory, resources.size());
        ResourceContainerImpl.setResourceContainerData(resources, resourceContainer);
        return resourceContainer;
    }

    public static void setResourceContainerData(List<Optional<ResourceAmount>> resources, ResourceContainer resourceContainer) {
        for (int i = 0; i < resources.size(); ++i) {
            int ii = i;
            resources.get(i).ifPresent(resource -> resourceContainer.set(ii, (ResourceAmount)resource));
        }
    }
}

