/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class InWorldNetworkNodeContainerImpl
implements InWorldNetworkNodeContainer {
    private final BlockEntity blockEntity;
    private final NetworkNode node;
    private final String name;
    private final int priority;
    private final ConnectionStrategy connectionStrategy;
    @Nullable
    private final Supplier<Object> keyProvider;

    public InWorldNetworkNodeContainerImpl(BlockEntity blockEntity, NetworkNode node, String name, int priority, ConnectionStrategy connectionStrategy, @Nullable Supplier<Object> keyProvider) {
        this.blockEntity = blockEntity;
        this.node = node;
        this.name = name;
        this.priority = priority;
        this.connectionStrategy = connectionStrategy;
        this.keyProvider = keyProvider;
    }

    @Override
    public NetworkNode getNode() {
        return this.node;
    }

    @Override
    public void addOutgoingConnections(ConnectionSink sink) {
        this.connectionStrategy.addOutgoingConnections(sink);
    }

    @Override
    public boolean canAcceptIncomingConnection(Direction incomingDirection, BlockState connectingState) {
        return this.connectionStrategy.canAcceptIncomingConnection(incomingDirection, connectingState);
    }

    @Override
    public BlockState getBlockState() {
        return this.blockEntity.getBlockState();
    }

    @Override
    public boolean isRemoved() {
        return this.blockEntity.isRemoved();
    }

    @Override
    public GlobalPos getPosition() {
        return GlobalPos.of((ResourceKey)Objects.requireNonNull(this.blockEntity.getLevel()).dimension(), (BlockPos)this.blockEntity.getBlockPos());
    }

    @Override
    public BlockPos getLocalPosition() {
        return this.blockEntity.getBlockPos();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @Nullable
    public Object createKey() {
        return this.keyProvider != null ? this.keyProvider.get() : null;
    }
}

