/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class StorageBlock<T extends BlockEntity>
extends AbstractBaseBlock
implements EntityBlock {
    private final AbstractBlockEntityTicker<T> ticker = new AbstractBlockEntityTicker<T>(this, () -> provider.getBlockEntityType()){

        public void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
            if (blockEntity instanceof AbstractBaseNetworkNodeContainerBlockEntity) {
                AbstractBaseNetworkNodeContainerBlockEntity networkNode = (AbstractBaseNetworkNodeContainerBlockEntity)blockEntity;
                networkNode.updateActiveness(blockState, null);
                networkNode.doWork();
            }
        }
    };
    private final StorageBlockProvider provider;

    public StorageBlock(BlockBehaviour.Properties properties, StorageBlockProvider provider) {
        super(properties);
        this.provider = provider;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return RefinedStorageApi.INSTANCE.createStorageBlockEntity(pos, state, this.provider);
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return this.ticker.get(level, type);
    }
}

