/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.SecurityCardData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractSecurityCardContainerMenu
extends AbstractBaseContainerMenu
implements ScreenSizeListener {
    protected final Inventory playerInventory;
    private final List<SecurityCardData.Permission> permissions;

    protected AbstractSecurityCardContainerMenu(MenuType<?> menuType, int syncId, Inventory playerInventory, SecurityCardData securityCardData) {
        super(menuType, syncId);
        this.playerInventory = playerInventory;
        this.disabledSlot = securityCardData.slotReference();
        this.permissions = securityCardData.permissions();
    }

    protected AbstractSecurityCardContainerMenu(MenuType<?> menuType, int syncId, Inventory playerInventory, SlotReference disabledSlot) {
        super(menuType, syncId);
        this.playerInventory = playerInventory;
        this.disabledSlot = disabledSlot;
        this.permissions = new ArrayList<SecurityCardData.Permission>();
        this.resized(0, 0, 0);
    }

    List<SecurityCardData.Permission> getPermissions() {
        return this.permissions;
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        this.resetSlots();
        this.addPlayerInventory(this.playerInventory, 8, playerInventoryY);
    }

    public void setPermission(PlatformPermission permission, boolean allowed) {
        if (this.disabledSlot == null) {
            return;
        }
        this.disabledSlot.resolve(this.playerInventory.player).ifPresent(stack -> this.setPermission((ItemStack)stack, permission, allowed));
    }

    private void setPermission(ItemStack stack, PlatformPermission permission, boolean allowed) {
        Item item = stack.getItem();
        if (item instanceof AbstractSecurityCardItem) {
            AbstractSecurityCardItem securityCardItem = (AbstractSecurityCardItem)item;
            securityCardItem.setPermission(stack, permission, allowed);
        }
    }

    public void resetPermissionServer(PlatformPermission permission) {
        if (this.disabledSlot == null) {
            return;
        }
        this.disabledSlot.resolve(this.playerInventory.player).ifPresent(stack -> this.resetPermissionServer((ItemStack)stack, permission));
    }

    private void resetPermissionServer(ItemStack stack, PlatformPermission permission) {
        Item item = stack.getItem();
        if (item instanceof AbstractSecurityCardItem) {
            AbstractSecurityCardItem securityCardItem = (AbstractSecurityCardItem)item;
            securityCardItem.resetPermission(stack, permission);
        }
    }

    SecurityCardData.Permission resetPermission(PlatformPermission permission) {
        boolean allowed = permission.isAllowedByDefault();
        C2SPackets.sendSecurityCardResetPermission(permission);
        return this.updatePermissionLocally(permission, allowed, false);
    }

    SecurityCardData.Permission changePermission(PlatformPermission permission, boolean selected) {
        C2SPackets.sendSecurityCardPermission(permission, selected);
        return this.updatePermissionLocally(permission, selected, true);
    }

    private SecurityCardData.Permission updatePermissionLocally(PlatformPermission permission, boolean allowed, boolean dirty) {
        SecurityCardData.Permission localPermission = this.permissions.stream().filter(p -> p.permission() == permission).findFirst().orElseThrow();
        int index = this.permissions.indexOf(localPermission);
        SecurityCardData.Permission updatedLocalPermission = new SecurityCardData.Permission(localPermission.permission(), allowed, dirty);
        this.permissions.set(index, updatedLocalPermission);
        return updatedLocalPermission;
    }
}

