/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;

class CraftingGridResultSlot
extends ResultSlot {
    private final CraftingGrid craftingGrid;

    CraftingGridResultSlot(Player player, CraftingGrid craftingGrid, int x, int y) {
        super(player, (CraftingContainer)craftingGrid.getCraftingMatrix(), (Container)craftingGrid.getCraftingResult(), 0, x, y);
        this.craftingGrid = craftingGrid;
    }

    public ItemStack onQuickCraft(Player player) {
        int crafted;
        ItemStack singleResultStack = this.getItem().copy();
        int maxCrafted = singleResultStack.getMaxStackSize();
        try (ExtractTransaction transaction = this.craftingGrid.startExtractTransaction(player, false);){
            for (crafted = 0; ItemStack.isSameItemSameComponents((ItemStack)singleResultStack, (ItemStack)this.getItem()) && crafted < maxCrafted; crafted += singleResultStack.getCount()) {
                this.doTake(player, transaction, singleResultStack);
            }
        }
        return singleResultStack.copyWithCount(crafted);
    }

    public void onTake(Player player, ItemStack stack) {
        if (player.level().isClientSide()) {
            return;
        }
        try (ExtractTransaction transaction = this.craftingGrid.startExtractTransaction(player, true);){
            this.doTake(player, transaction, stack);
        }
    }

    private void doTake(Player player, ExtractTransaction transaction, ItemStack stack) {
        this.fireCraftingEvents(player, stack.copy());
        CraftingInput.Positioned positioned = this.craftingGrid.getCraftingMatrix().asPositionedCraftInput();
        CraftingInput input = positioned.input();
        int left = positioned.left();
        int top = positioned.top();
        NonNullList<ItemStack> remainingItems = this.craftingGrid.getRemainingItems(player, input);
        for (int y = 0; y < input.height(); ++y) {
            for (int x = 0; x < input.width(); ++x) {
                int index = x + left + (y + top) * this.craftingGrid.getCraftingMatrix().getWidth();
                ItemStack matrixStack = this.craftingGrid.getCraftingMatrix().getItem(index);
                int recipeIndex = x + y * input.width();
                ItemStack remainingItem = (ItemStack)remainingItems.get(recipeIndex);
                if (!remainingItem.isEmpty()) {
                    this.useIngredientWithRemainingItem(player, index, remainingItem);
                    continue;
                }
                if (matrixStack.isEmpty()) continue;
                this.useIngredient(player, transaction, index, matrixStack);
            }
        }
        this.craftingGrid.getCraftingMatrix().changed();
    }

    private void useIngredientWithRemainingItem(Player player, int index, ItemStack remainingItem) {
        ItemStack matrixStack = this.decrementMatrixSlot(index);
        if (matrixStack.isEmpty()) {
            this.craftingGrid.getCraftingMatrix().setItem(index, remainingItem);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)matrixStack, (ItemStack)remainingItem)) {
            remainingItem.grow(matrixStack.getCount());
            this.craftingGrid.getCraftingMatrix().setItem(index, remainingItem);
        } else if (!player.getInventory().add(remainingItem)) {
            player.drop(remainingItem, false);
        }
    }

    private void useIngredient(Player player, ExtractTransaction transaction, int index, ItemStack matrixStack) {
        if (matrixStack.getCount() > 1 || !transaction.extract(ItemResource.ofItemStack(matrixStack), player)) {
            this.decrementMatrixSlot(index);
        }
    }

    private ItemStack decrementMatrixSlot(int index) {
        RecipeMatrixContainer matrix = this.craftingGrid.getCraftingMatrix();
        matrix.removeItem(index, 1);
        return matrix.getItem(index);
    }

    private void fireCraftingEvents(Player player, ItemStack crafted) {
        crafted.onCraftedBy(player.level(), player, crafted.getCount());
        Platform.INSTANCE.onItemCrafted(player, crafted, (CraftingContainer)this.craftingGrid.getCraftingMatrix());
        Container container = this.container;
        if (container instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder recipeHolder = (RecipeCraftingHolder)container;
            recipeHolder.awardUsedRecipes(player, List.of(crafted));
        }
    }
}

