/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategyFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.constructordestructor.BlockBreakDestructorStrategy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public class BlockBreakDestructorStrategyFactory
implements DestructorStrategyFactory {
    private static final ItemStack DEFAULT_TOOL = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
    private static final List<UpgradeMapping> UPGRADE_MAPPINGS = List.of(new UpgradeMapping(com.refinedmods.refinedstorage.common.content.Items.INSTANCE::getSilkTouchUpgrade, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, 1), new UpgradeMapping(com.refinedmods.refinedstorage.common.content.Items.INSTANCE::getFortune3Upgrade, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 3), new UpgradeMapping(com.refinedmods.refinedstorage.common.content.Items.INSTANCE::getFortune2Upgrade, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 2), new UpgradeMapping(com.refinedmods.refinedstorage.common.content.Items.INSTANCE::getFortune1Upgrade, (ResourceKey<Enchantment>)Enchantments.FORTUNE, 1));

    @Override
    public Optional<DestructorStrategy> create(ServerLevel level, BlockPos pos, Direction direction, UpgradeState upgradeState, boolean pickupItems) {
        ItemStack tool = DEFAULT_TOOL.copy();
        BlockBreakDestructorStrategyFactory.enchantTool(level, upgradeState, tool);
        return Optional.of(new BlockBreakDestructorStrategy(level, pos, direction, tool));
    }

    private static void enchantTool(ServerLevel level, UpgradeState upgradeState, ItemStack tool) {
        for (UpgradeMapping upgradeMapping : UPGRADE_MAPPINGS) {
            if (!upgradeState.has(upgradeMapping.upgradeItemSupplier.get())) continue;
            level.holderLookup(Registries.ENCHANTMENT).get(upgradeMapping.enchantment).ifPresent(enchantment -> tool.enchant((Holder)enchantment, upgradeMapping.level));
            return;
        }
    }

    private record UpgradeMapping(Supplier<UpgradeItem> upgradeItemSupplier, ResourceKey<Enchantment> enchantment, int level) {
    }
}

