/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.mojang.datafixers.util.Pair;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativesScreen;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternTypeButton;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputClientTooltipComponent;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixResourceSlot;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class PatternGridScreen
extends AbstractGridScreen<PatternGridContainerMenu>
implements PatternGridContainerMenu.PatternGridListener {
    static final int INSET_PADDING = 4;
    static final int INSET_WIDTH = 138;
    static final int INSET_HEIGHT = 71;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/pattern_grid.png");
    private static final MutableComponent CREATE_PATTERN = IdentifierUtil.createTranslation("gui", "pattern_grid.create_pattern");
    private static final MutableComponent CLEAR = IdentifierUtil.createTranslation("gui", "pattern_grid.clear");
    private static final int CREATE_PATTERN_BUTTON_SIZE = 16;
    private static final WidgetSprites CREATE_PATTERN_BUTTON_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/create_pattern"), IdentifierUtil.createIdentifier("widget/create_pattern_disabled"), IdentifierUtil.createIdentifier("widget/create_pattern_focused"), IdentifierUtil.createIdentifier("widget/create_pattern_disabled"));
    private static final WidgetSprites CLEAR_BUTTON_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/clear"), IdentifierUtil.createIdentifier("widget/clear_disabled"), IdentifierUtil.createIdentifier("widget/clear_focused"), IdentifierUtil.createIdentifier("widget/clear_disabled"));
    @Nullable
    private Button createPatternButton;
    @Nullable
    private Button clearButton;
    @Nullable
    private PatternGridRenderer renderer;
    private final Map<PatternType, PatternTypeButton> patternTypeButtons = new EnumMap<PatternType, PatternTypeButton>(PatternType.class);
    private final Inventory playerInventory;
    private final Map<Pair<PlatformResourceKey, Set<ResourceLocation>>, ProcessingMatrixInputClientTooltipComponent> processingMatrixInputTooltipCache = new HashMap<Pair<PlatformResourceKey, Set<ResourceLocation>>, ProcessingMatrixInputClientTooltipComponent>();
    private final Map<PatternType, PatternGridRenderer> renderers = new EnumMap<PatternType, PatternGridRenderer>(PatternType.class);

    public PatternGridScreen(PatternGridContainerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 177);
        this.inventoryLabelY = 153;
        this.imageWidth = 193;
        this.imageHeight = 249;
        this.playerInventory = inventory;
    }

    @Override
    protected void init() {
        super.init();
        this.initRenderers();
        this.createPatternButton = this.createCreatePatternButton(this.leftPos + 152, this.topPos + this.imageHeight - this.bottomHeight + 32);
        this.addRenderableWidget((GuiEventListener)this.createPatternButton);
        this.addPatternTypeButtons(((PatternGridContainerMenu)this.getMenu()).getPatternType());
        this.clearButton = this.createClearButton();
        this.addRenderableWidget((GuiEventListener)this.clearButton);
        ((PatternGridContainerMenu)this.menu).setListener(this);
    }

    private void initRenderers() {
        for (PatternType type : PatternType.values()) {
            PatternGridRenderer typeRenderer = type.createRenderer((PatternGridContainerMenu)this.menu, this.leftPos, this.topPos, this.getInsetX(), this.getInsetY());
            if (type == ((PatternGridContainerMenu)this.getMenu()).getPatternType()) {
                this.renderer = typeRenderer;
            }
            typeRenderer.addWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
            }, x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.renderers.put(type, typeRenderer);
        }
    }

    private CustomButton createCreatePatternButton(int x, int y) {
        CustomButton button = new CustomButton(x, y, 16, 16, CREATE_PATTERN_BUTTON_SPRITES, b -> ((PatternGridContainerMenu)this.getMenu()).sendCreatePattern(), (Component)CREATE_PATTERN);
        button.setTooltip(Tooltip.create((Component)CREATE_PATTERN));
        button.active = ((PatternGridContainerMenu)this.getMenu()).canCreatePattern();
        return button;
    }

    private void addPatternTypeButtons(PatternType currentPatternType) {
        PatternType[] patternTypes = PatternType.values();
        for (int i = 0; i < patternTypes.length; ++i) {
            PatternType patternType = patternTypes[i];
            PatternTypeButton button = new PatternTypeButton(this.leftPos + 172, this.topPos + this.imageHeight - this.bottomHeight + 4 + i * 19, btn -> ((PatternGridContainerMenu)this.getMenu()).setPatternType(patternType), patternType, patternType == currentPatternType);
            this.patternTypeButtons.put(patternType, button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private CustomButton createClearButton() {
        CustomButton button = new CustomButton(Objects.requireNonNull(this.renderer).getClearButtonX(), Objects.requireNonNull(this.renderer).getClearButtonY(), 7, 7, CLEAR_BUTTON_SPRITES, b -> ((PatternGridContainerMenu)this.getMenu()).sendClear(), (Component)CLEAR);
        button.setTooltip(Tooltip.create((Component)CLEAR));
        return button;
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.createPatternButton != null) {
            this.createPatternButton.active = ((PatternGridContainerMenu)this.getMenu()).canCreatePattern();
        }
        if (this.renderer != null) {
            this.renderer.tick();
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.renderer != null) {
            this.renderer.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        if (this.renderer != null) {
            this.renderer.renderBackground(graphics, partialTicks, mouseX, mouseY);
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        super.renderTooltip(graphics, x, y);
        if (this.renderer != null) {
            this.renderer.renderTooltip(this.font, this.hoveredSlot, graphics, x, y);
        }
    }

    @Override
    protected void renderResourceSlots(GuiGraphics graphics) {
    }

    @Override
    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        return this.renderer != null && this.renderer.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY);
    }

    @Override
    protected void addResourceSlotTooltips(ResourceSlot resourceSlot, List<ClientTooltipComponent> tooltip) {
        ProcessingMatrixResourceSlot matrixSlot;
        if (resourceSlot instanceof ProcessingMatrixResourceSlot && (matrixSlot = (ProcessingMatrixResourceSlot)resourceSlot).isInput()) {
            Set<ResourceLocation> allowedAlternatives = ((PatternGridContainerMenu)this.getMenu()).getAllowedAlternatives(matrixSlot.getContainerSlot());
            if (matrixSlot.getResource() != null && !allowedAlternatives.isEmpty()) {
                Pair cacheKey = Pair.of((Object)matrixSlot.getResource(), allowedAlternatives);
                ProcessingMatrixInputClientTooltipComponent cached = this.processingMatrixInputTooltipCache.computeIfAbsent((Pair<PlatformResourceKey, Set<ResourceLocation>>)cacheKey, k -> new ProcessingMatrixInputClientTooltipComponent((PlatformResourceKey)k.getFirst(), (Set)k.getSecond()));
                tooltip.add(cached);
            }
        }
        super.addResourceSlotTooltips(resourceSlot, tooltip);
    }

    @Override
    protected Screen createResourceAmountScreen(ResourceSlot slot) {
        ProcessingMatrixResourceSlot matrixSlot;
        if (slot instanceof ProcessingMatrixResourceSlot && (matrixSlot = (ProcessingMatrixResourceSlot)slot).isInput()) {
            return new AlternativesScreen((Screen)this, this.playerInventory, ((PatternGridContainerMenu)this.getMenu()).getAllowedAlternatives(matrixSlot.getContainerSlot()), slot);
        }
        return super.createResourceAmountScreen(slot);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (this.renderer != null) {
            this.renderer.renderLabels(graphics, this.font, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        boolean clickedInRecipe;
        boolean bl = clickedInRecipe = this.renderer != null && this.renderer.mouseClicked(mouseX, mouseY, clickedButton);
        if (clickedInRecipe) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    @Override
    public void mouseMoved(double mx, double my) {
        if (this.renderer != null) {
            this.renderer.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    @Override
    public boolean mouseReleased(double mx, double my, int button) {
        return this.renderer != null && this.renderer.mouseReleased(mx, my, button) || super.mouseReleased(mx, my, button);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double z, double delta) {
        return this.renderer != null && this.renderer.mouseScrolled(x, y, z, delta) || super.mouseScrolled(x, y, z, delta);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        this.patternTypeButtons.values().forEach(button -> button.setSelected(false));
        this.patternTypeButtons.get((Object)newPatternType).setSelected(true);
        if (this.renderer != null) {
            this.renderer.patternTypeChanged(newPatternType);
        }
        this.renderer = Objects.requireNonNull(this.renderers.get((Object)newPatternType));
        this.renderer.patternTypeChanged(newPatternType);
        if (this.clearButton != null) {
            this.clearButton.setPosition(this.renderer.getClearButtonX(), this.renderer.getClearButtonY());
        }
    }

    @Override
    public void fuzzyModeChanged(boolean newFuzzyMode) {
        if (this.renderer != null) {
            this.renderer.fuzzyModeChanged(newFuzzyMode);
        }
    }

    private int getInsetX() {
        return this.leftPos + 8;
    }

    private int getInsetY() {
        return this.topPos + this.imageHeight - this.bottomHeight + 5;
    }
}

