/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerViewType;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class ViewTypeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type");
    private static final List<MutableComponent> SUBTEXT_VISIBLE = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.visible").withStyle(ChatFormatting.GRAY));
    private static final MutableComponent HELP_VISIBLE = IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.visible.help");
    private static final List<MutableComponent> SUBTEXT_NOT_FULL = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.not_full").withStyle(ChatFormatting.GRAY));
    private static final MutableComponent HELP_NOT_FULL = IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.not_full.help");
    private static final List<MutableComponent> SUBTEXT_ALL = List.of(IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.all").withStyle(ChatFormatting.GRAY));
    private static final MutableComponent HELP_ALL = IdentifierUtil.createTranslation("gui", "autocrafter_manager.view_type.all.help");
    private static final ResourceLocation SPRITE_VISIBLE = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/view_type/visible");
    private static final ResourceLocation SPRITE_NOT_FULL = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/view_type/not_full");
    private static final ResourceLocation SPRITE_ALL = IdentifierUtil.createIdentifier("widget/side_button/autocrafter_manager/view_type/all");
    private final AutocrafterManagerContainerMenu containerMenu;

    ViewTypeSideButtonWidget(AutocrafterManagerContainerMenu containerMenu) {
        super(ViewTypeSideButtonWidget.createPressAction(containerMenu));
        this.containerMenu = containerMenu;
    }

    private static Button.OnPress createPressAction(AutocrafterManagerContainerMenu containerMenu) {
        return btn -> containerMenu.setViewType(containerMenu.getViewType().toggle());
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.containerMenu.getViewType()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerViewType.VISIBLE -> SPRITE_VISIBLE;
            case AutocrafterManagerViewType.NOT_FULL -> SPRITE_NOT_FULL;
            case AutocrafterManagerViewType.ALL -> SPRITE_ALL;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.containerMenu.getViewType()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerViewType.VISIBLE -> SUBTEXT_VISIBLE;
            case AutocrafterManagerViewType.NOT_FULL -> SUBTEXT_NOT_FULL;
            case AutocrafterManagerViewType.ALL -> SUBTEXT_ALL;
        };
    }

    @Override
    protected Component getHelpText() {
        return switch (this.containerMenu.getViewType()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerViewType.VISIBLE -> HELP_VISIBLE;
            case AutocrafterManagerViewType.NOT_FULL -> HELP_NOT_FULL;
            case AutocrafterManagerViewType.ALL -> HELP_ALL;
        };
    }
}

