/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSearchMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.SearchModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.ViewTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class AutocrafterManagerScreen
extends AbstractStretchingScreen<AutocrafterManagerContainerMenu> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafter_manager.png");
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final ResourceLocation AUTOCRAFTER_NAME = IdentifierUtil.createIdentifier("autocrafter_manager/autocrafter_name");
    private static final int COLUMNS = 9;
    private static final int INACTIVE_COLOR = -10790053;
    private static final MutableComponent HELP_ALL = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.all.help");
    private static final MutableComponent HELP_PATTERN_INPUTS = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_inputs.help");
    private static final MutableComponent HELP_PATTERN_OUTPUTS = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.pattern_outputs.help");
    private static final MutableComponent HELP_AUTOCRAFTER_NAMES = IdentifierUtil.createTranslation("gui", "autocrafter_manager.search_mode.autocrafter_names.help");
    @Nullable
    private SearchFieldWidget searchField;

    public AutocrafterManagerScreen(AutocrafterManagerContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.inventoryLabelY = 75;
        this.imageWidth = 193;
        this.imageHeight = 176;
    }

    @Override
    protected void init(int rows) {
        super.init(rows);
        ((AutocrafterManagerContainerMenu)this.getMenu()).setListener(() -> {
            this.resize();
            this.updateScrollbar();
            this.scrollbarChanged(rows);
        });
        if (this.searchField == null) {
            this.searchField = new SearchFieldWidget(this.font, this.leftPos + 94 + 1, this.topPos + 6 + 1, 67, new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.setX(this.leftPos + 94 + 1);
            this.searchField.setY(this.topPos + 6 + 1);
        }
        this.updateScrollbar();
        this.addWidget((GuiEventListener)this.searchField);
        this.searchField.setResponder(value -> ((AutocrafterManagerContainerMenu)this.getMenu()).setQuery((String)value));
        this.addRenderableWidget((GuiEventListener)new SearchIconWidget(this.leftPos + 79, this.topPos + 5, () -> this.getSearchModeHelp().copy().withStyle(ChatFormatting.GRAY), this.searchField));
        this.addSideButton(new RedstoneModeSideButtonWidget(((AutocrafterManagerContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton(new ViewTypeSideButtonWidget((AutocrafterManagerContainerMenu)this.getMenu()));
        this.addSideButton(new SearchModeSideButtonWidget((AutocrafterManagerContainerMenu)this.getMenu(), this::getSearchModeHelp));
        this.addSideButton(new AutoSelectedSideButtonWidget(this.searchField));
    }

    private Component getSearchModeHelp() {
        return switch (((AutocrafterManagerContainerMenu)this.menu).getSearchMode()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerSearchMode.ALL -> HELP_ALL;
            case AutocrafterManagerSearchMode.PATTERN_INPUTS -> HELP_PATTERN_INPUTS;
            case AutocrafterManagerSearchMode.PATTERN_OUTPUTS -> HELP_PATTERN_OUTPUTS;
            case AutocrafterManagerSearchMode.AUTOCRAFTER_NAMES -> HELP_AUTOCRAFTER_NAMES;
        };
    }

    private void updateScrollbar() {
        int totalRows = ((AutocrafterManagerContainerMenu)this.menu).getGroups().stream().map(group -> group.isVisible() ? group.getVisibleRows() + 1 : 0).reduce(0, Integer::sum);
        this.updateScrollbar(totalRows);
    }

    @Override
    protected void scrollbarChanged(int rows) {
        super.scrollbarChanged(rows);
        int scrollbarOffset = this.getScrollbarOffset();
        for (int i = 0; i < ((AutocrafterManagerContainerMenu)this.menu).getAutocrafterSlots().size(); ++i) {
            AutocrafterManagerSlot slot = ((AutocrafterManagerContainerMenu)this.menu).getAutocrafterSlots().get(i);
            Platform.INSTANCE.setSlotY(slot, slot.getOriginalY() - scrollbarOffset);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.render(graphics, 0, 0, 0.0f);
        }
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    @Override
    protected void renderRows(GuiGraphics graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        if (!((AutocrafterManagerContainerMenu)this.menu).isActive()) {
            graphics.fill(RenderType.guiOverlay(), x + 7 + 1, y + 19 + 1, x + 7 + 162 - 1, y + 19 + 1 + 18 * rows - 2, -10790053);
            return;
        }
        this.renderGroups(graphics, x, y, topHeight, rows);
        this.renderSlotContents(graphics, mouseX, mouseY, y, topHeight, rows);
    }

    private void renderGroups(GuiGraphics graphics, int x, int y, int topHeight, int rows) {
        int rowX = x + 7;
        int rowY = y + topHeight - this.getScrollbarOffset();
        for (AutocrafterManagerContainerMenu.ViewGroup group : ((AutocrafterManagerContainerMenu)this.menu).getGroups()) {
            if (!group.isVisible()) continue;
            if (!AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, rowY)) {
                graphics.blitSprite(AUTOCRAFTER_NAME, rowX, rowY, 162, 18);
                graphics.drawString(this.font, group.getName(), rowX + 4, rowY + 6, 0x404040, false);
            }
            AutocrafterManagerScreen.renderGroup(graphics, y, topHeight, rows, group, rowX, rowY);
            rowY += (group.getVisibleRows() + 1) * 18;
        }
    }

    private static void renderGroup(GuiGraphics graphics, int y, int topHeight, int rows, AutocrafterManagerContainerMenu.ViewGroup group, int rowX, int rowY) {
        int j = 0;
        for (AutocrafterManagerContainerMenu.SubViewGroup subGroup : group.getSubViewGroups()) {
            for (int i = 0; i < subGroup.getVisibleSlots(); ++i) {
                int slotX = rowX + j % 9 * 18;
                int slotY = rowY + 18 + j / 9 * 18;
                if (!AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, slotY)) {
                    graphics.blitSprite(Sprites.SLOT, slotX, slotY, 18, 18);
                }
                ++j;
            }
        }
    }

    private void renderSlotContents(GuiGraphics graphics, int mouseX, int mouseY, int y, int topHeight, int rows) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (Slot slot : ((AutocrafterManagerContainerMenu)this.menu).getAutocrafterSlots()) {
            boolean hovering;
            if (AutocrafterManagerScreen.isOutOfFrame(y, topHeight, rows, this.topPos + slot.y)) continue;
            super.renderSlot(graphics, slot);
            boolean bl = hovering = mouseX >= slot.x + this.leftPos && mouseX < slot.x + this.leftPos + 16 && mouseY >= slot.y + this.topPos && mouseY < slot.y + this.topPos + 16;
            if (!slot.isActive() || !hovering) continue;
            AutocrafterManagerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slot.x, (int)slot.y, (int)0);
        }
        graphics.pose().popPose();
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof AutocrafterManagerSlot) {
            return;
        }
        super.renderSlot(guiGraphics, slot);
    }

    private static boolean isOutOfFrame(int y, int topHeight, int rows, int rowY) {
        return rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
    }

    @Override
    protected void renderStretchingBackground(GuiGraphics graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.blit(this.getTexture(), x, y + 18 * row, 0, textureY, this.imageWidth, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return 99;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

