/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.api.storage.TransferHelper;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.function.ToLongFunction;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.2")
public class GridOperationsImpl
implements GridOperations {
    private final RootStorage rootStorage;
    private final Actor actor;
    private final ToLongFunction<ResourceKey> maxAmountProvider;
    private final long singleAmount;

    public GridOperationsImpl(RootStorage rootStorage, Actor actor, ToLongFunction<ResourceKey> maxAmountProvider, long singleAmount) {
        this.rootStorage = rootStorage;
        this.actor = actor;
        this.maxAmountProvider = maxAmountProvider;
        this.singleAmount = singleAmount;
    }

    @Override
    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        long amount = this.getExtractableAmount(resource, extractMode);
        if (amount == 0L) {
            return false;
        }
        return TransferHelper.transfer(resource, amount, this.actor, this.rootStorage, destination, this.rootStorage) > 0L;
    }

    private long getExtractableAmount(ResourceKey resource, GridExtractMode extractMode) {
        long extractableAmount = this.getExtractableAmount(resource);
        return this.adjustExtractableAmountAccordingToExtractMode(extractMode, extractableAmount);
    }

    private long getExtractableAmount(ResourceKey resource) {
        long totalSize = this.rootStorage.get(resource);
        long maxAmount = this.maxAmountProvider.applyAsLong(resource);
        return Math.min(totalSize, maxAmount);
    }

    private long adjustExtractableAmountAccordingToExtractMode(GridExtractMode extractMode, long extractableAmount) {
        return switch (extractMode) {
            default -> throw new MatchException(null, null);
            case GridExtractMode.ENTIRE_RESOURCE -> extractableAmount;
            case GridExtractMode.HALF_RESOURCE -> {
                if (extractableAmount == 1L) {
                    yield 1L;
                }
                yield extractableAmount / 2L;
            }
            case GridExtractMode.SINGLE_RESOURCE -> Math.min(this.singleAmount, extractableAmount);
        };
    }

    @Override
    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        long amount = switch (insertMode) {
            default -> throw new MatchException(null, null);
            case GridInsertMode.ENTIRE_RESOURCE -> this.maxAmountProvider.applyAsLong(resource);
            case GridInsertMode.SINGLE_RESOURCE -> this.singleAmount;
        };
        return TransferHelper.transfer(resource, amount, this.actor, source, this.rootStorage, null) > 0L;
    }
}

