/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.externalstorage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExposedExternalStorage;
import com.refinedmods.refinedstorage.api.network.impl.storage.NetworkNodeStorageConfiguration;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.network.storage.StorageProvider;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorage;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageRepository;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

public class ExternalStorageNetworkNode
extends AbstractNetworkNode
implements StorageProvider {
    private final long energyUsage;
    private final StorageConfiguration storageConfiguration;
    private final ExposedExternalStorage storage;
    @Nullable
    private ExternalStorage externalStorage;

    public ExternalStorageNetworkNode(long energyUsage, LongSupplier clock) {
        this.energyUsage = energyUsage;
        this.storageConfiguration = new NetworkNodeStorageConfiguration(this);
        this.storage = new ExposedExternalStorage(this.storageConfiguration, clock);
    }

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void setTrackingRepository(TrackedStorageRepository trackingRepository) {
        this.storage.setTrackingRepository(trackingRepository);
    }

    public void initialize(ExternalStorageProvider provider) {
        this.storage.tryClearDelegate();
        this.externalStorage = new ExternalStorage(provider, this.storage);
        if (this.isActive()) {
            this.setVisible(true);
        }
    }

    @Override
    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        this.setVisible(newActive);
    }

    public boolean detectChanges() {
        return this.storage.detectChanges();
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    private void setVisible(boolean visible) {
        if (visible) {
            if (this.externalStorage == null) {
                return;
            }
            this.storage.setDelegate(this.externalStorage);
        } else {
            this.storage.tryClearDelegate();
        }
    }
}

