/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.energy;

import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnergyNetworkComponentImpl
implements EnergyNetworkComponent {
    private final Set<EnergyProvider> providers = new LinkedHashSet<EnergyProvider>();

    @Override
    public void onContainerAdded(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof EnergyProvider) {
            EnergyProvider provider = (EnergyProvider)((Object)networkNode);
            this.providers.add(provider);
        }
    }

    @Override
    public void onContainerRemoved(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof EnergyProvider) {
            EnergyProvider provider = (EnergyProvider)((Object)networkNode);
            this.providers.remove(provider);
        }
    }

    @Override
    public long getStored() {
        long stored = 0L;
        for (EnergyProvider provider : this.providers) {
            if (stored + provider.getStored() < 0L) {
                return Long.MAX_VALUE;
            }
            stored += provider.getStored();
        }
        return stored;
    }

    @Override
    public long getCapacity() {
        long capacity = 0L;
        for (EnergyProvider provider : this.providers) {
            if (capacity + provider.getCapacity() < 0L) {
                return Long.MAX_VALUE;
            }
            capacity += provider.getCapacity();
        }
        return capacity;
    }

    @Override
    public long extract(long amount) {
        long extracted = 0L;
        for (EnergyProvider provider : this.providers) {
            if ((extracted += provider.extract(amount - extracted)) == amount) break;
        }
        return extracted;
    }

    @Override
    public boolean contains(EnergyProvider energyProvider) {
        for (EnergyProvider provider : this.providers) {
            if (!provider.contains(energyProvider)) continue;
            return true;
        }
        return false;
    }
}

