/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self.teams;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.NameCache;
import shetiphian.core.platform.Services;
import shetiphian.core.self.teams.PacketTeamSync;
import shetiphian.core.self.teams.TeamHelper;

public final class PlayerTeam {
    private final String id;
    private Component displayName;
    @Nullable
    private UUID leader;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> members = new HashSet<UUID>();

    public static PlayerTeam create(String id, Player leader, Component displayName) {
        UUID uuid = leader != null ? leader.getUUID() : null;
        PlayerTeam team = new PlayerTeam(id, uuid, displayName);
        TeamHelper.TEAMS.put(id, team);
        if (leader != null) {
            TeamHelper.PLAYER_TEAM.put(uuid, team);
            team.syncChanges(leader);
        }
        TeamHelper.markDirty();
        return team;
    }

    public String getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<UUID> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public boolean isManager(UUID player) {
        return this.managers.contains(player);
    }

    public List<UUID> getManagers() {
        return ImmutableList.copyOf(this.managers);
    }

    private PlayerTeam(String id, UUID leader, Component displayName) {
        this.id = id;
        Object object = this.displayName = displayName != null ? displayName : Component.literal((String)id);
        if (leader != null) {
            this.leader = leader;
            this.managers.add(leader);
            this.members.add(leader);
        }
        NameCache.setTeamName(this.id, this.displayName.getString());
    }

    @Nullable
    UUID getLeader() {
        return this.leader;
    }

    boolean changeDisplayName(Component displayName) {
        Object object = displayName = displayName != null ? displayName : Component.literal((String)this.id);
        if (!this.displayName.equals((Object)displayName)) {
            this.displayName = displayName;
            TeamHelper.markDirty();
            TeamHelper.syncDisplayName(this.id, this.displayName.getString());
            return true;
        }
        return false;
    }

    void add(Player player) {
        UUID uuid = player.getUUID();
        this.members.add(uuid);
        TeamHelper.PLAYER_TEAM.put(uuid, this);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    void leave(Player player) {
        UUID uuid = player.getUUID();
        if (!uuid.equals(this.leader)) {
            this.managers.remove(uuid);
            this.members.remove(uuid);
            TeamHelper.PLAYER_TEAM.remove(uuid);
            TeamHelper.markDirty();
        }
        this.syncChanges(player);
    }

    void kick(Player player) {
        UUID uuid = player.getUUID();
        if (uuid.equals(this.leader)) {
            this.leader = null;
        }
        this.managers.remove(uuid);
        this.members.remove(uuid);
        TeamHelper.PLAYER_TEAM.remove(uuid);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    boolean promote(Player player) {
        UUID uuid = player.getUUID();
        if (!this.managers.contains(uuid)) {
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean demote(Player player) {
        UUID uuid = player.getUUID();
        if (!uuid.equals(this.leader) && this.managers.contains(uuid)) {
            this.managers.remove(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean transfer(Player player) {
        UUID uuid = player.getUUID();
        if (!uuid.equals(this.leader)) {
            this.leader = uuid;
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.PLAYER_TEAM.put(uuid, this);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    private void syncChanges(Player player) {
        if (player instanceof ServerPlayer) {
            Services.NETWORK.sendToPlayer((CustomPacketPayload)new PacketTeamSync(this, player), (ServerPlayer)player);
        }
    }

    byte getPlayerStatus(Player player) {
        UUID uuid = player.getUUID();
        return (byte)(this.members.contains(uuid) ? (this.leader == uuid ? 3 : (this.managers.contains(uuid) ? 2 : 1)) : 0);
    }

    static PlayerTeam load(String teamId, CompoundTag nbt, HolderLookup.Provider provider) {
        UUID leader = null;
        try {
            leader = nbt.contains("leader", 11) ? nbt.getUUID("leader") : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MutableComponent displayName = null;
        try {
            displayName = nbt.contains("display_name", 8) ? Component.Serializer.fromJson((String)nbt.getString("display_name"), (HolderLookup.Provider)provider) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlayerTeam team = new PlayerTeam(teamId, leader, (Component)displayName);
        if (nbt.contains("members", 9)) {
            nbt.getList("members", 11).forEach(player -> {
                try {
                    team.members.add(NbtUtils.loadUUID((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.contains("managers", 9)) {
            nbt.getList("managers", 11).forEach(player -> {
                try {
                    team.managers.add(NbtUtils.loadUUID((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return team;
    }

    CompoundTag write(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("display_name", Component.Serializer.toJson((Component)this.displayName, (HolderLookup.Provider)provider));
        if (this.leader != null) {
            nbt.putUUID("leader", this.leader);
        }
        ListTag memberNBT = new ListTag();
        this.members.forEach(player -> {
            try {
                memberNBT.add((Object)NbtUtils.createUUID((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.put("members", (Tag)memberNBT);
        ListTag adminNBT = new ListTag();
        this.managers.forEach(player -> {
            try {
                adminNBT.add((Object)NbtUtils.createUUID((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.put("managers", (Tag)adminNBT);
        return nbt;
    }

    public static void handleSyncPacket(PacketTeamSync data, UUID uuid) {
        if (data.status() > 0) {
            PlayerTeam team = TeamHelper.getTeam(data.teamId());
            if (team == null) {
                team = PlayerTeam.create(data.teamId(), null, data.teamName());
            }
            team.setClientSidePlayerStatus(data.status(), uuid);
        } else {
            PlayerTeam team = TeamHelper.PLAYER_TEAM.get(uuid);
            if (data.teamId().equals("$nil") || team != null && data.teamId().equals(team.getId())) {
                TeamHelper.PLAYER_TEAM.remove(uuid);
            }
            TeamHelper.TEAMS.remove(data.teamId());
        }
    }

    private void setClientSidePlayerStatus(byte status, UUID uuid) {
        if (status > 0) {
            switch (status) {
                case 3: {
                    this.leader = uuid;
                }
                case 2: {
                    this.managers.add(uuid);
                }
                case 1: {
                    this.members.add(uuid);
                }
            }
            TeamHelper.PLAYER_TEAM.put(uuid, this);
        }
    }
}

