/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.self;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import shetiphian.core.common.NameCache;
import shetiphian.core.platform.NeoForgeNetworkHelper;
import shetiphian.core.self.ConfigLoader;
import shetiphian.core.self.EventHandler;
import shetiphian.core.self.Registration;
import shetiphian.core.self.modintegration.ModIntegration;
import shetiphian.core.self.network.NetworkHandler;
import shetiphian.core.self.teams.TeamHelper;

@Mod(value="shetiphiancore")
public final class ModMain {
    public ModMain(ModContainer modContainer, IEventBus modEventBus) {
        new Registration(modEventBus);
        new ConfigLoader(modContainer, modEventBus);
        modEventBus.addListener(NetworkHandler::initialise);
        modEventBus.addListener(InterModEnqueueEvent.class, event -> ModIntegration.INSTANCE.init());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
    }

    private static class EventRelay
    extends EventHandler {
        private MinecraftServer bufferedServer = null;

        private EventRelay() {
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void serverStarting(ServerAboutToStartEvent event) {
            NeoForgeNetworkHelper.ACTIVE_SERVER = event.getServer();
            this.bufferedServer = event.getServer();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void serverStopped(ServerStoppedEvent event) {
            NeoForgeNetworkHelper.ACTIVE_SERVER = null;
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public void worldLoaded(LevelEvent.Load event) {
            ServerLevel world;
            if (this.bufferedServer != null && (world = this.bufferedServer.getLevel(Level.OVERWORLD)) != null) {
                NameCache.load(this.bufferedServer, world);
                TeamHelper.load(this.bufferedServer, world);
                this.bufferedServer = null;
            }
        }

        @SubscribeEvent
        public void RegisterCommandsEvent(RegisterCommandsEvent event) {
            this.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        @SubscribeEvent
        public void bonemealEvent(BonemealEvent event) {
            InteractionResult result = this.onApplyBonemeal(event.getState(), event.getLevel(), event.getPos());
            if (result.consumesAction()) {
                if (!event.getLevel().isClientSide()) {
                    event.getStack().shrink(1);
                }
                event.setSuccessful(true);
            }
        }

        @SubscribeEvent
        public void ItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
            this.onItemCrafted(event.getEntity(), event.getCrafting(), event.getInventory());
        }

        @SubscribeEvent
        public void playerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
            InteractionResult result = this.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getPos(), event.getHand(), event.getHitVec());
            if (result.consumesAction()) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }

        @SubscribeEvent
        public void entityJoinLevelEvent(EntityJoinLevelEvent event) {
            this.onEntityJoinedWorld(event.getEntity());
        }

        @SubscribeEvent
        public void entityLeaveLevelEvent(EntityLeaveLevelEvent event) {
            this.onEntityLeaveWorld(event.getEntity());
        }
    }
}

