/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.network;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class PacketHelpers {
    public static StreamCodec<ByteBuf, String> STRING_CODEC = new StreamCodec<ByteBuf, String>(){

        public void encode(ByteBuf buffer, String string) {
            if (Strings.isNullOrEmpty((String)string)) {
                string = "!null!";
            }
            Utf8String.write((ByteBuf)buffer, (CharSequence)string, (int)Short.MAX_VALUE);
        }

        public String decode(ByteBuf buffer) {
            String string = Utf8String.read((ByteBuf)buffer, (int)Short.MAX_VALUE);
            return string.equals("!null!") ? "" : string;
        }
    };
    public static StreamCodec<FriendlyByteBuf, String[]> STRINGS_CODEC = new StreamCodec<FriendlyByteBuf, String[]>(){

        public void encode(FriendlyByteBuf buffer, String ... strings) {
            int count = strings.length;
            buffer.writeVarInt(count);
            for (String string : strings) {
                STRING_CODEC.encode((Object)buffer, (Object)string);
            }
        }

        public String[] decode(FriendlyByteBuf buffer) {
            int count = buffer.readVarInt();
            String[] strings = new String[count];
            for (int index = 0; index < count; ++index) {
                strings[index] = (String)STRING_CODEC.decode((Object)buffer);
            }
            return strings;
        }
    };
    public static StreamCodec<RegistryFriendlyByteBuf, Component> COMPONENT_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Component>(){

        public void encode(RegistryFriendlyByteBuf buffer, Component component) {
            STRING_CODEC.encode((Object)buffer, (Object)Component.Serializer.toJson((Component)component, (HolderLookup.Provider)buffer.registryAccess()));
        }

        public Component decode(RegistryFriendlyByteBuf buffer) {
            return Component.Serializer.fromJson((String)((String)STRING_CODEC.decode((Object)buffer)), (HolderLookup.Provider)buffer.registryAccess());
        }
    };
    public static StreamCodec<RegistryFriendlyByteBuf, Component[]> COMPONENTS_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Component[]>(){

        public void encode(RegistryFriendlyByteBuf buffer, Component ... components) {
            int count = components.length;
            buffer.writeVarInt(count);
            for (Component component : components) {
                COMPONENT_CODEC.encode((Object)buffer, (Object)component);
            }
        }

        public Component[] decode(RegistryFriendlyByteBuf buffer) {
            int count = buffer.readVarInt();
            Component[] components = new Component[count];
            for (int index = 0; index < count; ++index) {
                components[index] = (Component)COMPONENT_CODEC.decode((Object)buffer);
            }
            return components;
        }
    };
    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack[]> ITEMS_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack[]>(){

        public void encode(RegistryFriendlyByteBuf buffer, ItemStack ... stacks) {
            int count = stacks.length;
            buffer.writeVarInt(count);
            for (ItemStack stack : stacks) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)stack);
            }
        }

        public ItemStack[] decode(RegistryFriendlyByteBuf buffer) {
            int count = buffer.readVarInt();
            ItemStack[] stacks = new ItemStack[count];
            for (int index = 0; index < count; ++index) {
                stacks[index] = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            return stacks;
        }
    };
    public static StreamCodec<ByteBuf, UUID> UUID_CODEC = new StreamCodec<ByteBuf, UUID>(){

        public void encode(ByteBuf buffer, UUID uuid) {
            STRING_CODEC.encode((Object)buffer, (Object)uuid.toString());
        }

        public UUID decode(ByteBuf buffer) {
            return UUID.fromString((String)STRING_CODEC.decode((Object)buffer));
        }
    };
}

