/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.client.model.data.RenderData;

public abstract class TileEntityBase
extends BlockEntity {
    protected TileEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected abstract void buildNBT(CompoundTag var1, HolderLookup.Provider var2);

    protected abstract void processNBT(CompoundTag var1, HolderLookup.Provider var2);

    protected void buildNBT_SaveOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    protected void processNBT_SaveOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    protected void buildNBT_SyncOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    protected void processNBT_SyncOnly(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    protected void buildNBT_Extended(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    protected void processNBT_Extended(CompoundTag nbtTag, HolderLookup.Provider provider) {
    }

    public final void saveAdditional(CompoundTag nbtTag, HolderLookup.Provider provider) {
        super.saveAdditional(nbtTag, provider);
        this.buildNBT(nbtTag, provider);
        this.buildNBT_Extended(nbtTag, provider);
        this.buildNBT_SaveOnly(nbtTag, provider);
    }

    public final void loadAdditional(CompoundTag nbtTag, HolderLookup.Provider provider) {
        super.loadAdditional(nbtTag, provider);
        this.processNBT(nbtTag, provider);
        this.processNBT_Extended(nbtTag, provider);
        if (nbtTag.getBoolean("sync_packet")) {
            this.processNBT_SyncOnly(nbtTag, provider);
        } else {
            this.processNBT_SaveOnly(nbtTag, provider);
        }
        if (this.level != null) {
            try {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbtTag = super.getUpdateTag(provider);
        this.buildNBT(nbtTag, provider);
        this.buildNBT_Extended(nbtTag, provider);
        this.buildNBT_SyncOnly(nbtTag, provider);
        nbtTag.putBoolean("sync_packet", true);
        return nbtTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public RenderData getModelRenderData() {
        return RenderData.EMPTY;
    }

    @ApiStatus.NonExtendable
    public void flagModelRenderDataForUpdate() {
    }
}

