/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.world.item.DyeColor;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public interface IRGB16 {
    public byte getRed();

    public byte getGreen();

    public byte getBlue();

    default public byte[] getValues() {
        return new byte[]{this.getRed(), this.getGreen(), this.getBlue()};
    }

    default public short getIndex() {
        return (short)(this.getRed() * 256 + this.getGreen() * 16 + this.getBlue());
    }

    default public int getColor() {
        return -16777216 + (this.getRed() * 17 << 16) + (this.getGreen() * 17 << 8) + this.getBlue() * 17;
    }

    default public byte getSimpleColor() {
        return RGB16Helper.getSimpleColor(this.getIndex());
    }

    default public DyeColor getDyeColor() {
        return DyeColor.byId((int)this.getSimpleColor());
    }

    default public String getTooltip() {
        return String.format("\u00a7c%s\u00a7a%s\u00a79%s", this.getRed(), this.getBlue(), this.getGreen());
    }

    default public String valueString() {
        return String.format("R:%s-G:%s-B:%s", this.getRed(), this.getBlue(), this.getGreen());
    }

    public RGB16 mutable();

    public ImmutableRGB16 immutable();
}

