/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.block.IBeaconBeamColorizer;
import shetiphian.core.common.block.IExtendedAwarenessBlock;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.TileEntityRGB16;

public class BlockRGB16
extends Block
implements EntityBlock,
IBeaconBeamColorizer,
IColored,
IExtendedAwarenessBlock,
IRGB16_Block {
    private final BlockEntityFactory<TileEntityRGB16> supplier;
    private final int[] tintedIndexes;

    public BlockRGB16(BlockBehaviour.Properties properties, BlockEntityFactory<TileEntityRGB16> supplier, int ... tintedIndexes) {
        super(properties);
        this.supplier = supplier;
        this.tintedIndexes = tintedIndexes.length == 0 ? null : tintedIndexes;
    }

    public BlockRGB16 callback(Consumer<BlockRGB16> consumer) {
        consumer.accept(this);
        return this;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.supplier.create(pos, state);
    }

    protected TileEntityRGB16 getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    @Override
    public MapColor getMapColor(BlockState state, BlockGetter world, BlockPos pos) {
        RGB16 rgb16;
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            return rgb16.getDyeColor().getMapColor();
        }
        return null;
    }

    @Override
    public boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Player player, InteractionHand hand, Direction side, Vec3 hitVec, String dyeName) {
        TileEntityRGB16 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((BlockGetter)world, pos)) != null) {
            RGB16 rgb16;
            if (!world.isClientSide() && (rgb16 = tile.getRGB16(player)) != null) {
                if (player == null) {
                    rgb16.setValues(dyeName);
                } else {
                    rgb16.recolor(player, dyeName);
                }
                Helpers.syncTile(tile);
            }
            if (player != null) {
                player.swing(hand);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getBeaconBeamColor(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        RGB16 rgb16;
        TileEntityRGB16 tile = this.getTile((BlockGetter)world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            return rgb16.getColor();
        }
        return DyeColor.WHITE.getTextureDiffuseColor();
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        RGB16 rgb16;
        TileEntityRGB16 tile;
        if (data.world != null && data.pos != null && (this.tintedIndexes == null || Arrays.stream(this.tintedIndexes).anyMatch(value -> value == index)) && (tile = this.getTile((BlockGetter)data.world, data.pos)) != null && (rgb16 = tile.getRGB16(null)) != null) {
            return rgb16.getColor();
        }
        return -1;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        Item item;
        RGB16 rgb16;
        ItemStack stack = new ItemStack((ItemLike)this);
        TileEntityRGB16 tile = this.getTile((BlockGetter)world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null && (item = stack.getItem()) instanceof IRGB16_Item) {
            IRGB16_Item item2 = (IRGB16_Item)item;
            item2.setRGB16(stack, rgb16);
        }
        return stack;
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends TileEntityRGB16> {
        public T create(BlockPos var1, BlockState var2);
    }
}

