/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.inventory.AssignableWorldlyContainer;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;

public class InventorySideAssignable
extends InventoryInternal
implements AssignableWorldlyContainer {
    private static final SlotGroup EMPTY = new SlotGroup("empty");
    private final List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();
    private byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    private byte defaultIndex = (byte)-1;
    private Direction blockDirection = Direction.SOUTH;

    public InventorySideAssignable(BlockEntity invOwner, String saveName, int invSize, String displayName) {
        super(invOwner, saveName, invSize, displayName);
    }

    public InventorySideAssignable(BlockEntity invOwner, String saveName, int invSize, String displayName, IContainerCallback callback) {
        super(invOwner, saveName, invSize, displayName, callback);
    }

    public InventorySideAssignable(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName) {
        super(invOwner, saveName, invSize, invStackLimit, displayName);
    }

    public InventorySideAssignable(BlockEntity invOwner, String saveName, int invSize, int invStackLimit, String displayName, IContainerCallback callback) {
        super(invOwner, saveName, invSize, invStackLimit, displayName, callback);
    }

    public InventorySideAssignable setup(int defaultIndex, SlotGroup ... groups) {
        this.slotGroups.clear();
        if (groups != null) {
            for (SlotGroup group : groups) {
                if (group == null || this.slotGroups.contains(group)) continue;
                this.slotGroups.add(group);
            }
        }
        this.defaultIndex = this.clamp(defaultIndex);
        return this;
    }

    @Override
    public int getGroupCount() {
        return this.slotGroups.size();
    }

    @Override
    public void setSideGroup(Direction side, int groupIndex) {
        if (side != null) {
            this.indexSide[side.get3DDataValue()] = this.clamp(groupIndex);
        }
    }

    public void setBlockDirection(Direction direction) {
        this.blockDirection = direction;
    }

    private byte clamp(int index) {
        return (byte)(index > -1 && index < this.slotGroups.size() ? index : -1);
    }

    @Override
    public byte[] getIndexes() {
        return this.indexSide;
    }

    @Override
    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbtTag, String name) {
        super.writeToNBT(provider, nbtTag, name);
        nbtTag.putByteArray("sidedWrapper", this.indexSide);
    }

    @Override
    public void readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTag, String name) {
        byte[] indexes;
        super.readFromNBT(provider, nbtTag, name);
        if (nbtTag.contains("sidedWrapper") && (indexes = nbtTag.getByteArray("sidedWrapper")).length == 6) {
            this.indexSide = indexes;
        }
    }

    private SlotGroup getGroup(Direction side) {
        try {
            if (this.blockDirection != null && side != null) {
                if (side.getAxis() != Direction.Axis.Y) {
                    switch (this.blockDirection) {
                        case NORTH: {
                            return this.slotGroups.get(this.indexSide[side.getOpposite().get3DDataValue()]);
                        }
                        case WEST: {
                            return this.slotGroups.get(this.indexSide[side.getCounterClockWise().get3DDataValue()]);
                        }
                        case EAST: {
                            return this.slotGroups.get(this.indexSide[side.getClockWise().get3DDataValue()]);
                        }
                    }
                }
                return this.slotGroups.get(this.indexSide[side.get3DDataValue()]);
            }
            return this.slotGroups.get(this.defaultIndex);
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    public int[] getSlotsForFace(Direction side) {
        return this.getGroup((Direction)side).slots.keySet().stream().mapToInt(i -> i).toArray();
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        if (Arrays.stream(this.getSlotsForFace(side)).anyMatch(value -> value == slot)) {
            return this.getGroup((Direction)side).slots.getOrDefault(slot, Action.NEITHER).canInsert() && this.canPlaceItem(slot, stack);
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        if (Arrays.stream(this.getSlotsForFace(side)).anyMatch(value -> value == slot)) {
            return this.getGroup((Direction)side).slots.getOrDefault(slot, Action.NEITHER).canExtract();
        }
        return false;
    }

    public static class SlotGroup {
        private final Component name;
        private final Map<Integer, Action> slots = new HashMap<Integer, Action>();

        public SlotGroup(String name) {
            this.name = Component.translatable((String)name);
        }

        public SlotGroup(String blockKey, String slotKey) {
            this.name = Component.translatable((String)blockKey).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)slotKey));
        }

        public SlotGroup(Component name) {
            this.name = name;
        }

        public SlotGroup add(int slotId, boolean insert, boolean extract) {
            this.slots.put(slotId, insert ? (extract ? Action.BOTH : Action.INSERT) : (extract ? Action.EXTRACT : Action.NEITHER));
            return this;
        }

        public SlotGroup add(int startId, int endId, boolean insert, boolean extract) {
            for (int slotId = startId; slotId <= endId; ++slotId) {
                this.add(slotId, insert, extract);
            }
            return this;
        }

        public Component getName() {
            return this.name;
        }
    }

    private static enum Action {
        INSERT,
        EXTRACT,
        BOTH,
        NEITHER;


        public boolean canInsert() {
            return this == BOTH || this == INSERT;
        }

        public boolean canExtract() {
            return this == BOTH || this == EXTRACT;
        }
    }
}

