/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryShifted
implements Container,
Nameable {
    protected final Container parent;

    public InventoryShifted(Container parent) {
        this.parent = parent;
    }

    protected abstract int shiftId(int var1);

    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slotId) {
        return this.parent.getItem(this.shiftId(slotId));
    }

    @NotNull
    public ItemStack removeItem(int slotId, int amount) {
        return this.parent.removeItem(this.shiftId(slotId), amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slotId) {
        return this.parent.removeItemNoUpdate(this.shiftId(slotId));
    }

    public void setItem(int slotId, @NotNull ItemStack stack) {
        this.parent.setItem(this.shiftId(slotId), stack);
    }

    public int getMaxStackSize() {
        return this.parent.getMaxStackSize();
    }

    public void setChanged() {
        this.parent.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.parent.stillValid(player);
    }

    public void startOpen(Player player) {
        this.parent.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.parent.stopOpen(player);
    }

    public boolean canPlaceItem(int slotId, @NotNull ItemStack stack) {
        return this.parent.canPlaceItem(this.shiftId(slotId), stack);
    }

    public boolean canTakeItem(Container container, int slotId, ItemStack stack) {
        return this.parent.canTakeItem(container, this.shiftId(slotId), stack);
    }

    public void clearContent() {
    }

    public boolean hasCustomName() {
        return false;
    }

    public Component getCustomName() {
        return this.getName();
    }

    public Component getDisplayName() {
        return this.getName();
    }
}

