/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.BlockInfo;
import shetiphian.core.common.NameCache;
import shetiphian.core.common.TagHelper;
import shetiphian.core.self.teams.PlayerTeam;
import shetiphian.core.self.teams.TeamHelper;

public class Helpers {
    public static final Random random = new Random();

    public static boolean setBlock(LevelAccessor world, BlockPos pos, BlockState state, boolean doBlockUpdate) {
        int update = doBlockUpdate ? 11 : 26;
        return world.setBlock(pos, state, update);
    }

    public static void syncTile(BlockEntity tile) {
        tile.setChanged();
        BlockState state = tile.getBlockState();
        Helpers.sync(tile.getLevel(), tile.getBlockPos(), state);
    }

    public static void sync(Level world, BlockPos pos, BlockState state) {
        world.sendBlockUpdated(pos, state, state, 11);
    }

    public static void updateLighting(BlockEntity tile) {
        tile.getLevel().getBrightness(LightLayer.BLOCK, tile.getBlockPos());
        BlockState state = tile.getBlockState();
        Helpers.sync(tile.getLevel(), tile.getBlockPos(), state);
    }

    public static Block getBlockDown(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock();
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static boolean giveItem(Player player, ItemStack stack) {
        return Helpers.giveItem(player, stack, SoundEvents.ITEM_PICKUP);
    }

    public static boolean giveItem(Player player, ItemStack stack, SoundEvent sound) {
        if (!player.getInventory().add(stack)) {
            Helpers.dropItem(player.level(), new BlockPos((int)player.getX(), (int)player.getY(), (int)player.getZ()), stack);
            return false;
        }
        if (sound != null) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), sound, player.getSoundSource(), 0.2f, ((player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return true;
    }

    public static void dropItem(Level world, BlockPos pos, ItemStack stack) {
        if (!world.isClientSide() && !stack.isEmpty()) {
            double rndX = (double)(world.random.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.random.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.random.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity entityItem = new ItemEntity(world, (double)pos.getX() + rndX, (double)pos.getY() + rndY, (double)pos.getZ() + rndZ, stack);
            entityItem.setPickUpDelay(10);
            world.addFreshEntity((Entity)entityItem);
        }
    }

    public static ItemStack findItemStack(String modId, String name) {
        return Helpers.findItemStack(1, modId, name);
    }

    public static ItemStack findItemStack(int count, String modId, String name) {
        return Helpers.findItemStack(count, ResourceLocation.fromNamespaceAndPath((String)modId, (String)name));
    }

    public static ItemStack findItemStack(int count, ResourceLocation resource) {
        Item item = (Item)BuiltInRegistries.ITEM.get(resource);
        if (item != null) {
            return new ItemStack((ItemLike)item, Math.max(count, 1));
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack findItemStack(int count, String tagId) {
        return Strings.isNullOrEmpty((String)tagId) ? ItemStack.EMPTY : Helpers.findItemStack(count, TagHelper.ITEMS.getTagKey(tagId));
    }

    public static ItemStack findItemStack(int count, TagKey<Item> tagKey) {
        Collection<Item> results = TagHelper.ITEMS.getCollection(tagKey);
        if (results != null && !results.isEmpty()) {
            for (Item item : results) {
                if (item == null) continue;
                return new ItemStack((ItemLike)item, count);
            }
        }
        return ItemStack.EMPTY;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return Helpers.areItemStacksEqual(stackA, stackB, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean excludeNBT) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        if (stackA.isEmpty() || stackB.isEmpty()) {
            return false;
        }
        return excludeNBT ? ItemStack.isSameItem((ItemStack)stackA, (ItemStack)stackB) : ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB);
    }

    public static void attemptAdd(List<ItemStack> list, ItemStack itemStack) {
        if (itemStack != null && itemStack.getCount() > 0) {
            list.add(itemStack);
        }
    }

    public static String getEntityName(LivingEntity entity) {
        return entity.getDisplayName().getString();
    }

    public static boolean isOP(Player player) {
        return player.hasPermissions(2);
    }

    public static boolean isCreativeOP(Player player) {
        return player.getAbilities().instabuild && Helpers.isOP(player);
    }

    public static String getPlayerTeamID(Player player) {
        PlayerTeam team;
        if (player != null && (team = TeamHelper.getTeam(player)) != null) {
            return team.getId();
        }
        return "";
    }

    public static String getTeamDisplayName(String teamID) {
        return !Strings.isNullOrEmpty((String)teamID) ? NameCache.getLastKnownTeamName(teamID) : teamID;
    }

    public static double getReach(Entity entity, boolean block) {
        return block ? 4.5 : 3.0;
    }

    public static int getSubShapeHit(Entity entity, BlockPos pos, VoxelShape ... shapes) {
        double distance = Helpers.getReach(entity, true);
        Vec3 vecStart = new Vec3(entity.xo, entity.yo + (double)entity.getEyeHeight(), entity.zo);
        Vec3 vecLook = entity.getViewVector(0.0f);
        Vec3 vecEnd = vecStart.add(vecLook.x * distance, vecLook.y * distance, vecLook.z * distance);
        int shapeIndex = -1;
        double hitDistance = 100.0;
        for (int index = 0; index < shapes.length; index = (int)((byte)(index + 1))) {
            double shapeDistance;
            BlockHitResult shapeHit = shapes[index].clip(vecStart, vecEnd, pos);
            if (shapeHit == null || !((shapeDistance = shapeHit.getLocation().distanceToSqr(vecStart)) < hitDistance)) continue;
            hitDistance = shapeDistance;
            shapeIndex = index;
        }
        return shapeIndex;
    }

    public static BlockHitResult fakeMOP(BlockPos pos, Direction face) {
        Vec3 vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        return new BlockHitResult(vec3, face, pos, false);
    }

    public static BlockHitResult rayTrace(Entity entity, double distance, float partialTicks) {
        distance = distance > 0.0 ? distance : Helpers.getReach(entity, true);
        return (BlockHitResult)entity.pick(distance, partialTicks, false);
    }

    public static Entity getLivingEntityInFront(Level world, Entity entity, double distance) {
        double d = distance = distance > 0.0 ? distance : Helpers.getReach(entity, false);
        if (entity == null || world == null || distance < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(entity.getPose()), entity.getZ());
        Vec3 vecLook = entity.getViewVector(1.0f);
        Vec3 vecEnd = vecStart.add(vecLook.x * distance, vecLook.y * distance, vecLook.z * distance);
        AABB scanBox = new AABB(Math.min(vecStart.x, vecEnd.x), Math.min(vecStart.y, vecEnd.y), Math.min(vecStart.z, vecEnd.z), Math.max(vecStart.x, vecEnd.x), Math.max(vecStart.y, vecEnd.y), Math.max(vecStart.z, vecEnd.z));
        Entity theTarget = null;
        float closestHit = Float.POSITIVE_INFINITY;
        List entityList = entity.level().getEntities(entity, scanBox.inflate(2.0));
        if (entityList.isEmpty()) {
            return null;
        }
        for (Entity livingEntity : entityList) {
            float currentHit;
            Optional intercept;
            AABB boundingBox;
            if (!(livingEntity instanceof LivingEntity) || !livingEntity.isPickable() || (boundingBox = livingEntity.getBoundingBox()) == null || !(intercept = boundingBox.clip(vecStart, vecEnd)).isPresent() || !((currentHit = (float)((Vec3)intercept.get()).distanceTo(vecStart)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            theTarget = livingEntity;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(Level world, Entity entity, double reach, boolean includeLiquids) {
        HitResult mop = Helpers.getMovingObjectPosition(world, entity, includeLiquids, reach);
        if (mop instanceof BlockHitResult) {
            return new BlockInfo(world, (BlockHitResult)mop);
        }
        return null;
    }

    public static HitResult getMovingObjectPosition(Level world, Entity entity, boolean includeLiquids, double reach) {
        double d = reach = reach > 0.0 ? reach : Helpers.getReach(entity, true);
        if (entity == null || world == null || reach < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(entity.getPose()), entity.getZ());
        Vec3 vecLook = entity.getViewVector(1.0f);
        Vec3 vecEnd = vecStart.add(vecLook.x * reach, vecLook.y * reach, vecLook.z * reach);
        return world.clip(new ClipContext(vecStart, vecEnd, ClipContext.Block.OUTLINE, includeLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity));
    }
}

