/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

@Deprecated(forRemoval=true)
public class CapabilityHelper {
    public static FluidHelper FLUIDS = new FluidHelper();
    public static ItemHelper ITEMS = new ItemHelper();
    public static ComparatorHelper COMPARATOR = new ComparatorHelper();

    public static class FluidHelper {
        public boolean isFluidContainer(ItemStack stack) {
            return !stack.isEmpty() && this.getHandler(stack) != null;
        }

        public boolean isFluidContainer(Level world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IFluidHandler getHandler(ItemStack stack) {
            IFluidHandler handler = null;
            if (!stack.isEmpty()) {
                handler = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
            }
            return handler;
        }

        @Nullable
        public IFluidHandler getHandler(Level world, BlockPos pos, Direction facing) {
            if (world != null && pos != null) {
                return (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)facing);
            }
            return null;
        }
    }

    public static class ItemHelper {
        public boolean isItemContainer(ItemStack stack) {
            return !stack.isEmpty() && this.getHandler(stack) != null;
        }

        public boolean isItemContainer(Level world, BlockPos pos, Direction facing) {
            return world != null && pos != null && this.getHandler(world, pos, facing) != null;
        }

        @Nullable
        public IItemHandler getHandler(ItemStack stack) {
            return stack.isEmpty() ? null : (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        }

        @Nullable
        public IItemHandler getHandler(Level world, BlockPos pos, Direction facing) {
            return world == null || pos == null ? null : (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)facing);
        }
    }

    public static class ComparatorHelper {
        public int getInputOverride(IFluidHandler handler) {
            if (handler != null) {
                int fluidCount = 0;
                float fullness = 0.0f;
                int tankCount = handler.getTanks();
                for (int tank = 0; tank < tankCount; ++tank) {
                    FluidStack stack = handler.getFluidInTank(tank);
                    if (stack == FluidStack.EMPTY || stack.getAmount() <= 0) continue;
                    fullness += (float)stack.getAmount() / (float)handler.getTankCapacity(tank);
                    ++fluidCount;
                }
                return Mth.floor((float)((fullness /= (float)tankCount) * 14.0f)) + (fluidCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(IItemHandler handler) {
            if (handler != null) {
                int itemCount = 0;
                float fullness = 0.0f;
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (stack.isEmpty()) continue;
                    fullness += (float)stack.getCount() / (float)Math.min(handler.getSlotLimit(slot), stack.getMaxStackSize());
                    ++itemCount;
                }
                return Mth.floor((float)((fullness /= (float)handler.getSlots()) * 14.0f)) + (itemCount > 0 ? 1 : 0);
            }
            return 0;
        }

        public int getInputOverride(Level world, BlockPos pos) {
            if (world != null && pos != null) {
                IFluidHandler fluidHandler;
                int counter = 0;
                float value = 0.0f;
                IItemHandler itemHandler = ITEMS.getHandler(world, pos, null);
                if (itemHandler != null) {
                    value += (float)this.getInputOverride(itemHandler) / 15.0f;
                    ++counter;
                }
                if ((fluidHandler = FLUIDS.getHandler(world, pos, null)) != null) {
                    value += (float)this.getInputOverride(fluidHandler) / 15.0f;
                    ++counter;
                }
                if (counter > 0) {
                    return Mth.floor((float)(value / (float)counter * 14.0f)) + (value > 0.0f ? 1 : 0);
                }
            }
            return 0;
        }
    }
}

