/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model.data;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.client.model.data.DataKey;

public final class RenderData {
    public static final RenderData EMPTY = RenderData.builder().build();
    private final Map<DataKey<?>, Object> dataMap;

    private RenderData(Map<DataKey<?>, Object> dataMap) {
        this.dataMap = dataMap;
    }

    public Set<DataKey<?>> getMap() {
        return this.dataMap.keySet();
    }

    public boolean isEmpty() {
        return this == EMPTY || this.dataMap.isEmpty();
    }

    public boolean has(DataKey<?> dataKey) {
        return this.dataMap.containsKey(dataKey);
    }

    @Nullable
    public <T> T get(DataKey<T> dataKey) {
        return (T)this.dataMap.get(dataKey);
    }

    public Builder derive() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static final class Builder {
        private final Map<DataKey<?>, Object> dataMap = new IdentityHashMap();

        private Builder(@Nullable RenderData parent) {
            if (parent != null) {
                this.dataMap.putAll(parent.dataMap);
            }
        }

        @Contract(value="_, _ -> this")
        public <T> Builder with(DataKey<T> dataKey, T value) {
            Preconditions.checkState((boolean)dataKey.test(value), (Object)"The provided value is invalid for this key.");
            this.dataMap.put(dataKey, value);
            return this;
        }

        @Contract(value="-> new")
        public RenderData build() {
            return new RenderData(Collections.unmodifiableMap(this.dataMap));
        }
    }
}

