/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.client.model.BasicBakedModel;

public class AssembledBakedModel
extends BasicBakedModel {
    private final List<BakedModel> parts;
    private final ItemTransforms transforms;
    private final TextureAtlasSprite particles;

    public AssembledBakedModel(List<BakedModel> parts, ItemTransforms ... transforms) {
        this.parts = parts;
        this.transforms = transforms.length > 0 ? transforms[0] : null;
        this.particles = this.parts.isEmpty() ? null : this.parts.getLast().getParticleIcon();
    }

    public AssembledBakedModel(List<BakedModel> parts, TextureAtlasSprite particles, ItemTransforms ... transforms) {
        this.parts = parts;
        this.transforms = transforms.length > 0 ? transforms[0] : null;
        this.particles = particles;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (BakedModel model : this.parts) {
            quads.addAll(model.getQuads(state, side, rand));
        }
        return quads;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.particles != null ? this.particles : super.getParticleIcon();
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.transforms != null ? this.transforms : super.getTransforms();
    }

    @Override
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

