/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking;

import java.util.HashMap;
import java.util.Optional;
import net.xalcon.torchmaster.logic.entityblocking.ILightSerializer;
import net.xalcon.torchmaster.logic.entityblocking.dreadlamp.DreadLampSerializer;
import net.xalcon.torchmaster.logic.entityblocking.megatorch.MegatorchSerializer;

public class LightSerializerRegistry {
    private static HashMap<String, ILightSerializer> registry = new HashMap();

    public static void registerLightSerializer(ILightSerializer serializer) {
        String lightSerializerKey = serializer.getSerializerKey();
        if (lightSerializerKey == null) {
            throw new RuntimeException("SerializerKey is null! " + serializer.getClass().getCanonicalName());
        }
        if (registry.containsKey(lightSerializerKey)) {
            throw new RuntimeException("lightSerializer '" + lightSerializerKey + "' already exists");
        }
        registry.put(lightSerializerKey, serializer);
    }

    public static Optional<ILightSerializer> getLightSerializer(String lightSerializerKey) {
        ILightSerializer serializer = registry.get(lightSerializerKey);
        if (serializer == null) {
            return Optional.empty();
        }
        return Optional.of(registry.get(lightSerializerKey));
    }

    static {
        LightSerializerRegistry.registerLightSerializer(MegatorchSerializer.INSTANCE);
        LightSerializerRegistry.registerLightSerializer(DreadLampSerializer.INSTANCE);
    }
}

